#ifndef TCPSENDER
#define TCPSENDER


#include "PeriodicAction.H"
#include "socket_functions.h"
#include <string>
//in Makefile#define MAXMSG 4096 

class TCPSender : public Object{
public:
    char  servName[100];
    unsigned short int servPort;
    
    TCPSender (char * servName_, unsigned int servPort_ );
    ~TCPSender();
    
    void CloseConnection();
    int IODescriptor();
    bool isTrialToConnectSuccesful();    
    void Send (char *msg );
    void Reset();
    
    void Receive ();
//Syncronous receive. If you are not sure there will be data to read, schedule this receive with IONotifier or something. Otherwise it will block
    string ReturnNew (); 
private:
    struct sockaddr_in server;
    
            //file descriptor
    int socketItself;
    
    bool comMode;//better called isCommUp
    unsigned long int retryingTime;//in usec
    bool newReceived;
    char receivedStream[MAXMSG];
    
    PeriodicAction tryingConnect;
  
//this->CloseConnection method should be capitalized for some consistency. Put the change should be propagated. class Make up!
    virtual void process ();
};




#endif
