#include <iostream>
#include "PeriodicAction.hxx"
//the next class derives from sigc++ Object, so its methods are callable as slots
class Counter:public Object
{
public:
    int max;
    int count;
    int incr;
    
    Counter(int max_, int incr_)
            :max(max_),incr(incr_),count(0)
        {};
    bool isIncrementPossible()
        {
            count+=incr;
            cout<<"Counter by "<<incr<<" to "<<max<<" is at "<<count<<"\n";
//be careful on blocking here by putting endl or flushing cout!!!! It spoils the whole thing, because blocks the internal thread
            if(count<=max) return true;
            else return false;
        };
    void PrintIAmDone()
        {
            cout<<"Counter by "<<incr<<" to "<<max<<" is done!\n";
        };
    
};
bool end;

void endMe()
{
    end=true;
}

int main()
{
    end=false;
    Counter byTwo(100,2), byThree(100,3);
    
    PeriodicAction byTwoEachSec(1000000);//in microsec
//byTwoEachSec will increment byTwo counter until isIncrementPossible returns false (will DoWhile(isIncrementPossible) ). 
    byTwoEachSec.DoWhile(slot(byTwo,&Counter::isIncrementPossible));
//DoWhile action has been set to the slot (callback) method isIncrementPossible, member of Counter class,    
    byTwoEachSec.FinallyDo(slot(byTwo,&Counter::PrintIAmDone));
//finally, when PeriodicAction finishes, that is, when isIncrementPossible returns false, will call byTwo.PrintIAmDone
    byTwoEachSec.Start();
    
    PeriodicAction byThreeEachTwoSec(2000000);
    byThreeEachTwoSec.DoWhile(slot(byThree,&Counter::isIncrementPossible));
    byThreeEachTwoSec.FinallyDo(slot(endMe));
//in these case FinallyDo is not initialized to a method of an object, but to a global function. How can one provide this flexible interface without signal/slots
    byThreeEachTwoSec.Start();
    
    while(!end){
    }
    

    return 0;
}
