#include "MStarList.h"

void MStarList::RemoveTwins(Double_t radius)
{
    MStarList stars;

    Int_t numfirst=0;

    while (1)
    {
        int idx;
        MStar *first=NULL;
        for (idx=numfirst; idx<GetMax(); idx++)
            if ((first = (*this)[idx]))
                break;

        if (!first)
            return;

        MStarListIter Next(this, *first, radius);
        Delete(idx);

        MStar *pos;
        Float_t mx=0;
        Float_t my=0;
        Int_t cnt=0;
        while ((pos=Next()))
        {
            mx += pos->GetX();
            my += pos->GetY();
            Delete(pos);
            cnt++;
        }
        mx /= cnt;
        my /= cnt;

        AddAt(idx, mx, my, cnt);
        numfirst = idx+1;
    }
}
