#ifndef COSY_Timer
#define COSY_Timer

struct timeval;

class ostream;

class Timer
{
    friend ostream &operator<<(ostream &out, Timer &t);
private:
    double fMs;
    double fDiv;

    int fSec;
    int fSecs;
    int fMin;
    int fHor;
    int fDay;
    int fMon;
    int fYea;

    double fMjd;

    char fDateStr[30];

    //void Set(const long mjd);

public:
    Timer() : fMs(0), fSec(0), fSecs(0), fMin(0), fHor(0), fDay(0), fMon(0), fYea(0), fMjd(0) {}
    Timer(double t);
    Timer(struct timeval *tv);
    Timer(const Timer &t);

    void SetTimer(int tv_sec, double tv_usec);
    void SetTimer(const struct timeval *tv);

    void GetTimeval(struct timeval *tv) const;

    int GetSecs() { return fSecs; }

    double Now(); //[s]
    double GetMjd() const { return fMjd/*+fDiv*/; }

    virtual void SetMjd(double mjd);

    int Day() const   { return fDay; }
    int Month() const { return fMon; }
    int Year() const  { return fYea; }

    int H() const { return fHor; }
    int M() const { return fMin; }
    int S() const { return fSec; }

    const char *GetTimeStr();

    void Print();

    operator double() const; //[s]
};

ostream &operator<<(ostream &out, Timer &t);

#endif
