#ifndef COSY_MGEmbeddedCanvas
#define COSY_MGEmbeddedCanvas

//
// This File contains the declaration of the MGCoordinates-class
//
//   Author: Thomas Bretz
//   Version: V1.0 (1-8-2000)


#ifndef ROOT_TRootEmbeddedCanvas
#include <TRootEmbeddedCanvas.h>
#endif

class TList;
class TCanvas;

class MGEmbeddedCanvas : public TRootEmbeddedCanvas
{
private:
    Bool_t fModified;

protected:

    TCanvas    *fCanvas;
    TList      *fList;

    UInt_t  fWidth; // const: rootcint/TMemberInspector
    Float_t fRange; // const: rootcint/TMemberInspector
    Float_t fPix;   // const: rootcint/TMemberInspector

    void InitCanvas();

public:
    MGEmbeddedCanvas(const char *name, const TGWindow* p,
                     UInt_t width, Double_t range);
    ~MGEmbeddedCanvas();

    void Resize(TGDimension size);
    void Resize(UInt_t w, UInt_t h);
    void MoveResize(Int_t x, Int_t y, UInt_t w, UInt_t h);

    void UpdateCanvas();

    void SetModified() { fModified = kTRUE; }

    void SetNoContextMenu();

    ClassDef(MGEmbeddedCanvas, 0)
};

#endif // MGSKYPOSITION_H
