/*-----------------------------------------------------------------------------
nmtm.h -- NMT Master Interface

Copyright (c) 1994 JANZ Computer AG
All Rights Reserved

Created 95/02/23 by Soenke Hansen
Version 1.16 of 99/10/26

Prototype declarations of functions defined in nmtm.c.

-----------------------------------------------------------------------------*/


#ifndef nmtm_DEFINED
#define nmtm_DEFINED

#ifdef __cplusplus
extern "C" {
#endif

#include "defs.h"
#include "msg.h"
#include "cal.h"
#include "nmts.h"

/*--------- Indication and Confirmation Primitives --------------------------*/

/* Origin of status/error confirmation */
#define NMTM_LOCAL	0	/* on NMT Master */
#define NMTM_REMOTE	1	/* on NMT Slave */

/* NMT error code for locally generated errors */
#define LOC_ERR		1

/* Components of service confirmation message (spec == M_NMTM_*) */
#define nmtm_nid	u.m2.b[0]		/* Node ID */
#define nmtm_org	u.m2.b[1]		/* origin (local or remote) */
#define nmtm_err	u.m2.b[2]		/* error code */
#define nmtm_errs	u.m2.b[3]		/* error specifier */
#define nmtm_xpct	u.m2.b[4]		/* toggle/state expected */
#define nmtm_download	u.m2.b[4]		/* download expected by slave*/
#define nmtm_real	u.m2.b[5]		/* toggle/state real */

#define	NMTM_TIMEOUT_ERROR	TIMEOUT_ERR	/* value of nmtm_errs */
#define	NMTM_TOGGLE_ERROR	TOGGLE_ERR	/* value of nmtm_errs */
#define	NMTM_STATE_ERROR	STATE_ERR	/* value of nmtm_errs */


/* Components of configuration message (spec == M_NMTM_*) */
#define nmtm_conf_nid		u.m2.b[0]	/* Node ID */
#define nmtm_conf_subspec_lo	u.m2.b[1]	/* subspec lo */
#define nmtm_conf_subspec_hi	u.m2.b[2]	/* subspec hi */
#define nmtm_conf_errspec	u.m2.b[3]	/* error specifier */
#define nmtm_conf_fail_reason	u.m1.w[3]	/* failure reason */
#define nmtm_conf_verify_result	u.m1.w[3]	/* verify result */
#define nmtm_conf_verify_reason	u.m1.w[4]	/* verify failure reason */
#define nmtm_conf_appl_spec_a	u.m1.w[4]	/* application specific a */
#define nmtm_conf_appl_spec_b	u.m1.w[5]	/* application specific b */
#define nmtm_conf_appl_spec_c	u.m1.w[6]	/* application specific c */
#define nmtm_conf_appl_spec_d	u.m1.w[7]	/* application specific d */
/*--------- Remote Node Objects ---------------------------------------------*/

/* Remote Node type definition */
struct rnode {
	NmtAddr		addr;		/* NMT Address */
	int		state;		/* remote node state */
	WORD_t		ugt;		/* guard time in 100 usecs */
	WORD_t		userGuardId;		/* user def. guard ID at CANopen remote nodes */
	BYTE_t		nclass;		/* node class */
	BYTE_t		flags;		/* flags related to error control */
	OBJECT		obj;		/* associated CAL object */
	BYTE_t		type;		/* CANopen (1) / CAL (0) node */
	BYTE_t		guardErrType;	/* flags related to guard error type */
	BYTE_t		xpctTogState;	/* rnode expected state/togglebit */
	BYTE_t		realTogState;	/* rnodes real state/togglebit */
	BYTE_t		downloadRqd;	/* rnode requires download if set 1 */
};

#define NIL_RNODE	(struct rnode *)0

/* Table of all Remote Nodes */
extern struct rnode *RemoteNodes[];

/* Remote Node States */
#define RN_NON_EXISTENT		(-1)
#define RN_DISCONNECTED		0
#define RN_CONNECTED		PREPARING
#define RN_PREPARED		PREPARED
#define RN_OPERATIONAL		OPERATIONAL
#define RN_PRE_OPERATIONAL	PRE_OPERATIONAL

/*--------- Some guarding stuff -------------------------------------------*/

/* Values for error control flags */
#define ARRIVED         0x01    /* guarding COB from remote node arrived */
#define RAISED          0x02    /* timeout error raised at current grd period */
#define INDICATED       0x04    /* timeout error occ. and was ind. to user */
#define INHIBIT_GUARD   0x08    /* Node guarding was inhibited  */
#define	STATE_CH_RAISED	0x10	/* signals a state change error */
#define	STATE_CH_INDICATED 0x20	/* state change error was indicated...*/
#define	TOGGLE_RAISED	0x40	/* signals a toggle error */
/* 	TOGGLE         (0x80)   from bit-representation (see below) is used */
/* for error control, too. */

/* Values for error report flags */
#define	TIMEOUT_ERR	0x01	/* error reported to user was timeout-error */
#define	TOGGLE_ERR	0x02	/* error reported to user was tgl.-bit-error */
#define	STATE_ERR	0x04	/* error reported to user was state-error */

/* guarding protocols bit representation */
#define TOGGLE          0x80    /* toggle bit of guarding protocol */
#define STATE_MASK	0x7f	/* state relevant bits of guarding prot. */

/*--------- Prototypes ------------------------------------------------------*/

/* Create and initialize the NMT Master. */
extern void InitNmtM(WORD_t, WORD_t, int, void (*)());

/* Configure NMT master. */
extern void ConfigNmtM(WORD_t, WORD_t, int, WORD_t);

/* Remove the NMT Master. Free the resources it holds. */
extern void DeleteNmtM(void);

/* Add Remote Node service */
extern int CreateRemoteNode(NmtAddr *);
extern int AddRemoteNode(NmtAddr *);

/* Add Remote CANopen Node service */
extern int CreateRemoteCOPNode(NmtAddr *, WORD_t, BYTE_t);
extern int CreateRemoteCOPNodeDefGuardId(NmtAddr *, WORD_t, BYTE_t, WORD_t);
extern int AddRemoteCOPNode(NmtAddr *, WORD_t, BYTE_t);
extern int AddRemoteCOPNodeDefGuardId(NmtAddr *, WORD_t, BYTE_t, WORD_t);

/* Request Guarding the CANopen Remote Nodes */
extern int GuardingRemoteCOPNodeReq(int);

/* Remove Remote Node service */
extern void RemoveRemoteNode(NmtAddr *);

/* Get a remote node state */
extern int GetRemoteNodeState(NmtAddr *);

/* Request Connect Remote Node */
extern int ConnectRemoteNodeReq(NmtAddr *, int);

/* Request Prepare Remote Node */
extern int PrepareRemoteNodeReq(int);

/* Request enter pre-operational state of Remote Node */
extern int EnterPreOperationalStateReq(int);

/* Request Reset_Node state of Remote Node */
extern int ResetNodeReq(int);

/* Request Reset_Communication state of Remote Node */
extern int ResetCommunicationReq(int);

/* Request Start Remote Node */
extern int StartRemoteNodeReq(int);

/* Request Stop Remote Node */
extern int StopRemoteNodeReq(int);

/* Request Disconnect Remote Node */
extern int DisconnectRemoteNodeReq(int);

/* Request Identify Remote Nodes */
extern int IdentifyRemoteNodesReq(int, int);

/* Request Initiate Config Download */
extern int ConfDownloadStartReq(int, int, int, int, BYTE_t *);

/* Response Continue Config Download */
extern int ConfDownloadContReq(int, int, int, BYTE_t *);

/* Request Abort Configuration */
extern int NmAbortConfigTransferReq(int, int, int);

/* Request Verify Configuration */
extern int NmVerifyConfigTransferReq(int, int);

#if DEBUG>0
extern void guard_node(int);
#endif

#ifdef __cplusplus
}
#endif

#endif /* !nmtm_DEFINED */
