#ifndef COSY_MCeCoCom
#define COSY_MCeCoCom

#ifndef ROOT_TString
#include <TString.h>
#endif

#ifndef COSY_MTcpIpIO
#include "MTcpIpIO.h"
#endif

#ifndef MARS_MTime
#include "MTime.h"
#endif

class MCeCoCom : public MTcpIpIO
{
private:
    enum ComStatus_t
    {
        kCmdReceived,
        kNoCmdReceived,
        kComProblem
    };

    //TString fCommand;     // report string of the current system
    MTime   fT;           // time of last report received
    char    fStatus;      // current status of this system
    int     fCCStatus;    // global status of CC

    ComStatus_t fComStat; // communication status

    Float_t fHumidity;         // [%]
    Float_t fTemperature;      // [deg] celsius
    Float_t fWindSpeed;        // [km/h]
    Float_t fSolarRadiation;   // [W/m^2] IR-Radiation

    Int_t   fAlarmCounter;     // Counter for alarm cases

    virtual bool InterpreteCmd(TString cmd, TString str);

    bool InterpreteReport(TString &str);
    bool InterpreteStr(TString str);

public:
    MCeCoCom::MCeCoCom(const char *cmd, MLog &out=gLog)
        : MTcpIpIO(out), /*fCommand(cmd),*/ fStatus(0), fComStat(kNoCmdReceived), fSolarRadiation(-1)
    {
    }

    bool Send(const char *cmd, const char *str);
    void SetStatus(Byte_t s) { fStatus=s; }

    Float_t GetHumidity() const { return fHumidity; }
    Float_t GetTemperature() const { return fTemperature; }
    Float_t GetWindSpeed() const { return fWindSpeed; }

    TString GetWeather() const;
    Int_t   GetWeatherStatus() const;

    Bool_t  HasAlarm() const { return fAlarmCounter>3; }
};

#endif
