#ifndef MARS_MVideo
#define MARS_MVideo

#ifndef MAGIC_MAGIC
#include "MAGIC.h"
#endif

#ifndef __CINT__
#ifndef __LINUX_VIDEODEV_H
#include "videodev.h" // video4linux
#endif
#endif

class MVideo
{
private:
    TString fPath; // Device path

    int fFileDesc; // File descriptor

    char *fMapBuffer;

protected:
    struct video_capability fCaps;      // Device capabilities
    struct video_channel    fChannel;   // Channel information
    struct video_mbuf       fBuffer;    // Buffer information
    struct video_picture    fProp;      // Picture properties

private:
    int Ioctl(int req, void *opt, bool allowirq=true) const;

    void Reset();

    Bool_t GetCapabilities();
    Bool_t GetProperties();
    Bool_t Init(Int_t channel);

    // Conversion functions
    TString GetDevType(int type) const;
    TString GetChannelFlags(Int_t flags) const;
    TString GetChannelType(Int_t type) const;
    TString GetPalette(Int_t pal) const;

public:
    MVideo(const char *path="/dev/video");
    virtual ~MVideo() { Close(); }

    // Getter
    Bool_t IsOpen() const { return fFileDesc>0 && fMapBuffer; }
    Bool_t CanCapture() const;
    Int_t  GetNumBuffers() const;

    Int_t  GetWidth() const;
    Int_t  GetHeight() const;

    // Control
    Bool_t Open(Int_t channel=0);
    Int_t  Close();

    Bool_t SetChannel(Int_t chan);

    // Image capture
    Bool_t CaptureStart(unsigned int frame) const;
    Int_t  CaptureWait(unsigned int frame, char **ptr) const;

    // Support
    void Print() const;

    // hardware features
    //void SetPicPar(int  bright, int  hue, int  contrast);
    //void GetPicPar(int *bright, int *hue, int *contrast);

    //ClassDef(MVideo, 0) // Interface to Video4Linux at a simple level

};

#endif
