#ifndef MTHREAD_H
#define MTHREAD_H

#include <pthread.h>

class MThread 
{
private:
    bool fIsRunning;
    bool fIsDetached;
    bool fStop;

    pthread_t *fThread;

    void *fReturn;

    int fPriority;

    static void *MapThread(void *arg);
    void *RunThread();
    virtual void *Thread() = 0;

public:
    MThread(bool start=true);
    virtual ~MThread();

    bool SetPriority(int prio);

    void Detach();

    void Start();
    void Stop();

    bool HasStopFlag() const { return fStop; }
};

#endif
