#ifndef MSGQUEUE_H
#define MSGQUEUE_H

#include <pthread.h>

#define WM_NULL 0x0000

class MsgQueue
{
private:
    int fBreak;
    int fStart;
    int fStop;

    int fMsg;     // Message identifier
    void *fMp;    // Message Parameter
    void *fSize;  // Message Parameter Size
    void *fRc;    // Proc return code

    pthread_t       fThread;
    pthread_mutex_t fMuxMsg;
    pthread_cond_t  fCondMsg;
    pthread_mutex_t fMuxRc;
    pthread_cond_t  fCondRc;

    static void *MapThread(void *arg);

    void Thread();

public:
    MsgQueue();
    virtual ~MsgQueue();

    int Break() const { return fBreak; }

    virtual void *Proc(int msg, void *mp1);

    void *PostMsg(int msg, void *mp1, int size);
};

#endif
