/*-----------------------------------------------------------------------------
nmts.h -- NMT Slave, Node

Copyright (c) 1994 JANZ Computer AG
All Rights Reserved

Created 94/10/11 by Soenke Hansen
Version 1.17 of 99/04/26

Various definitions: NMT Address type, NMT command specifiers, node states,
macros for data indicated to the NMT User.
Prototypes of functions defined in nmts.c.

-----------------------------------------------------------------------------*/


#ifndef nmts_DEFINED
#define nmts_DEFINED

#ifdef __cplusplus
extern "C" {
#endif

#include "defs.h"
#include "msg.h"

/* Components of service confirmation message */
#define nmts_state	u.m1.w[0]	/* Node State */
#define nmts_error	u.m1.w[0]	/* Node Error */
#define nmts_errcode	u.m1.w[1]	/* error code ident. from BCAN_EVENT */
#define nmts_errcode_e0	u.m1.w[2]	/*   BCAN_EVENT additional infos */
#define nmts_errcode_e1	u.m1.w[3]	/*   BCAN_EVENT additional infos */
#define nmts_errcode_e2	u.m1.w[4]	/*   BCAN_EVENT additional infos */
#define nmts_errcode_e3	u.m1.w[5]	/*   BCAN_EVENT additional infos */
#define nmts_keep	u.m2.b[2]	/* Node Prepare Protocol */

/* Values of node error flag nmts_error */
#define NE_LOCAL_OCCURRED	0x0003  /* local error occurred */
#define NE_LOCAL_RESOLVED	0x0002  /* local error resolved */
#define NE_REMOTE_OCCURRED	0x000c  /* remote error occurred */
#define NE_REMOTE_RESOLVED	0x0008  /* remote error resolved */

/* Components of configuration message (spec == M_NMTS_*) */
#define nmts_conf_subspec_lo	u.m1.w[0]	/* subspec low */
#define nmts_conf_subspec_hi	u.m1.w[1]	/* subspec high */

#define nmts_conf_errspec	u.m1.w[2]	/* error specifier */

#define nmts_conf_fail_reason	u.m1.w[2]	/* failure reason */
#define nmts_conf_appl_spec_a	u.m1.w[3]	/* application specific a */
#define nmts_conf_appl_spec_b	u.m1.w[4]	/* application specific b */
#define nmts_conf_appl_spec_c	u.m1.w[5]	/* application specific c */
#define nmts_conf_appl_spec_d	u.m1.w[6]	/* application specific d */

#define nmts_conf_verify_cs_a	u.m1.w[2]	/* verify checksum a */
#define nmts_conf_verify_cs_b	u.m1.w[3]	/* verify checksum b */
#define nmts_conf_verify_cs_c	u.m1.w[4]	/* verify checksum c */
#define nmts_conf_verify_cs_d	u.m1.w[5]	/* verify checksum d */
    
/* Type definition of NMT address */
struct nmt_addr {
	BYTE_t	modname[8];	/* module name */
	BYTE_t	modid;		/* module Id */
};
#if TYPEDEFS == 1
typedef struct nmt_addr NmtAddr;
#else
#define NmtAddr struct nmt_addr
#endif

/* Copy an NMT Address */
extern void NmtAddrCopy(
	NmtAddr	*,	/* target address */
	NmtAddr	*	/* source address */
);

/* The Node State */
extern int NodeState;

/* Node State values */
#define DISCONNECTED		1
#define CONNECTING		2
#define PREPARING		3
#define PREPARED		4
#define OPERATIONAL		5
#define PRE_OPERATIONAL		127

/* The Node Id */
extern BYTE_t NodeId;

/* There are three CAL Objects associated with the NMT Slave */
extern struct calo *NodeO;	/* receives COBs with Id=0 */
extern struct calo *NmtSlave;	/* receives COBs with Id=2026 */
extern struct calo *NodeErrO;	/* receives guarding COBs, Node Events */

/* Command specifiers in NMT Protocol with COB-ID=0 */
#define NMT_CS_START		  1	/* Start Node, COB-ID=0 */
#define NMT_CS_STOP		  2	/* Stop Node, COB-ID=0 */
#define NMT_CS_DISCONNECT	  3	/* Disconnect Node, COB-ID=0 */

/* Command specifiers in NMT Protocol with COB-ID=0 relevant for CANopen */
#define NMT_CS_ENTER_PRE_OPERATIONAL 	128  /* enter pre-operational state */
#define NMT_CS_RESET_NODE	   	129  /* Reset Node */
#define NMT_CS_RESET_COMMUNICATION 	130  /* Reset Communication */

/* Command specifiers in NMT Protocol with COB-IDs=2025,2026 */
#define NMT_CS_CONNECT_NAME	  1	/* Node Connect, Module Name */
#define NMT_CS_CONNECT_ID	  4	/* Node Connect, Module Id */
#define NMT_CS_CONNECT_ASSIGN	  2	/* Node Connect, assign phase */
#define NMT_CS_PREPARE		  3	/* Node Prepare */
#define NMT_CS_CONFIG		  5	/* Configuration Service */
#define NMT_CS_IDENTIFY		  6	/* Node Identify */

/* Nil command specifier */
#define NMT_CS_NIL		  0	/* not used by protocols */


					/* timepoint of guard start: */
#define START_AT_IDENTIFY	0x01	/* receiving of a identify msg */
#define	START_AT_GUARD_ID_RX	0x02	/* receiving on guard ID */

#define NMTS_CONF_DOWNLOAD_ACK	0x01	/* mux: configure nmt slave to use */
					/* acknowledge at configuration */
					/* download */
#define NMTS_CONF_DL_ACK_OFF	0x00	/* flag: use acknowledge */
#define NMTS_CONF_DL_ACK_ON	0x01	/* flag: don't use acknowledge (dflt.)*/

/* Subsequent command (sub-) specifiers in Nmt Configuration protocol */
#define NMT_CONF_DIR_NO		0
#define NMT_CONF_DIR_UPLOAD	1
#define NMT_CONF_DIR_DOWNLOAD	2
/* master commands */
#define	NMT_MCS_DL_SEGMENT_REQ	0
#define	NMT_MCS_INITIATE_DL_REQ	0x20
#define	NMT_MCS_INITIATE_UL_REQ	0x40
#define	NMT_MCS_UL_SEGMENT_REQ	0x60
#define	NMT_MCS_ABORT_CONF_REQ	0x80
#define	NMT_MCS_VERIFY_CONF_REQ	0xa0
#define MCS_MASK		0xe0

/* slave commands */
#define	NMT_SCS_UL_SEGMENT_RES	0
#define	NMT_SCS_DL_SEGMENT_RES	0x20	
#define	NMT_SCS_INITIATE_UL_RES	0x40
#define	NMT_SCS_INITIATE_DL_RES	0x60
#define	NMT_SCS_ABORT_CONF_REQ	0x80
#define	NMT_SCS_VERIFY_CONF_RES	0xa0
#define SCS_MASK		0xe0

#define NMT_CONFIG_TOGGLE	0x10

/* leaving place for 2 byte subspec, 4 byte whole */
/* size, 1 byte dblk-size and 1 byte cs */
#define NMT_CONFIG_HEAD_SIZE	8
#define NMT_CONFIG_DBLK_SIZE	MSGLEN - NMT_CONFIG_HEAD_SIZE 
#define NMT_CONFIG_MORE_SEG_INDICATOR	0x01	/* bit position in protocol */
#define	NMT_CONFIG_MORE_BYTES		0
#define	NMT_CONFIG_NOMORE_BYTES		1

#define NMT_CONFIG_MAX_SEG_DATA	5
#define NMT_CONFIG_SIZE_INDICATOR	0x01

/* bitpositions in cs to user */
#define	NMT_MORE	1		/* more date will follow */
#define	NMT_SUCCESS	4		/* success indication */

/* indication of success/fail of last nmt transfer */
#define	NMT_CONFIG_TRANSFER_FAILED	0
#define	NMT_CONFIG_TRANSFER_SUCCESS	1
#define XFER_FAIL	NMT_CONFIG_TRANSFER_FAILED
#define XFER_SUCC	NMT_CONFIG_TRANSFER_SUCCESS

/* Allocate and initialize NMT Slave */
extern void InitNmtS(
	WORD_t	,	/* timeout interval */
	void	(*)()	/* user handler indication/confirmation */
);

/* Deallocate NMT Slave */
extern void DeleteNmtS(void);

/* Create Node Service */
extern void CreateNode(NmtAddr *, unsigned);

/* Create CANopen Node Service */
extern void CreateCOPNode(NmtAddr *, unsigned);

/* Config CANopen Node Service */
extern void ConfigCOPNode(WORD_t, int, BYTE_t);

/* Delete Node Service */
extern void DeleteNode(void);

/* Identify Node Service */
extern void IdentifyNode(void);

/* Disconnect Node Service */
extern void DisconnectNode(void);

/* Connect Node Service */
extern int ConnectNode(int, WORD_t, BYTE_t);

/* Respond Prepare Remote Node Service */
extern int PrepareRemoteNodeRes(unsigned);

/* Configure Configuration download acknowledge */
extern void NsConfigConfDownloadAck(WORD_t);

/* nmt configuration download acknowledge from user  */
extern void NsConfAckUser(void);

/* Request Abort Configuration */
extern int NsAbortConfigTransferReq(int,int);

/* Response Verify Configuration */
extern int NsVerifyConfigTransferRes(BYTE_t, BYTE_t);

#ifdef __cplusplus
}
#endif

#endif /* !nmts_DEFINED */
