#include "Slalib.h"

#include <time.h>
#include <iostream.h>  // cout

#include "coord.h"

#include "slalib.h"

ClassImp(Slalib);

Slalib::Slalib(MObservatory::LocationName_t key) : Timer(), MObservatory(key)
{
}

Slalib::~Slalib()
{
}

void Slalib::SetMjd(double mjd)
{
    Timer::SetMjd(mjd);
    fAlpha = slaGmst(mjd) + GetElong();
}

ZdAz Slalib::XYZ2ZdAz(double coord[3]) const
{
    //
    // -- xyz to spherical coordinates --
    //
    double ra, dec;
    slaDcc2s(coord, &ra, &dec);

    //
    // radec[rad] -> hadec[rad]
    //
    const double ha = fAlpha-ra;

    //
    // hadec[rad] -> altaz[rad]
    //
    double alt, az;
    slaDe2h(ha, dec, GetPhi(), &az, &alt);

    return ZdAz(kPiDiv2-alt, az);
}
