#ifndef SLALIB_H
#define SLALIB_H

#include <TROOT.h>

#include "coord.h"
#include "timer.h"
#include "MObservatory.h"

class Slalib : public Timer, public MObservatory
{
private:
    double fAlpha;

public:
    Slalib(MObservatory::LocationName_t key);
    virtual ~Slalib();

    static Double_t Dms2Rad(Int_t deg, UInt_t min, Double_t sec)
    {
        /* pi/(180*3600):  arcseconds to radians */
#define DAS2R 4.8481368110953599358991410235794797595635330237270e-6
        return DAS2R * (60.0 * (60.0 * (Double_t)deg + (Double_t)min) + sec);
    }

    static Double_t Hms2Rad(Int_t hor, UInt_t min, Double_t sec)
    {
        /* pi/(12*3600):  seconds of time to radians */
#define DS2R 7.2722052166430399038487115353692196393452995355905e-5
        return DS2R * (60.0 * (60.0 * (Double_t)hor + (Double_t)min) + sec);
    }

    virtual void SetMjd(double mjd);

    double GetAlpha() const  { return fAlpha; }

    ZdAz   XYZ2ZdAz(double coord[3]) const;

    ClassDef(Slalib, 0)
};

#endif
