#ifndef PngReader_H
#define PngReader_H

#ifdef __CINT__
typedef unsigned long int pthread_t;
struct pthread_mutex_t;
struct pthread_cond_t;
struct timeval;
#else
#include <TROOT.h>
#include <pthread.h>
#include <unistd.h>
#include <sys/time.h>
#endif

class PixClient;

typedef unsigned char byte;

class PngReader
{
private:
    //
    // Geometry
    //
    static const int gfCols  = 768;
    static const int gfRows  = 576;
    static const int gfDepth = 3;

    int fStop;
    int fIsRunning;

    //
    // Thread interface
    //
    unsigned long fNum;

    char fImg[gfCols*gfRows];
    struct timeval fTime;

    pthread_t fThread;

    PixClient &fClient;

    //
    // Hardware dependant functions
    //
    char *GetImg(unsigned int frame);

    //
    // Execution thread which processes the pictures
    //
    void Thread();
    static void *MapThread(void *arg);

public:
    PngReader(PixClient &client);
    virtual ~PngReader();

    //
    // Starts, stops the execution
    //
    void ExitLoop()
    {
        fStop = 1;
        while (IsRunning())
            usleep(1);
    }

    //
    // flag if the execution is running or not
    //
    int IsRunning() const { return fIsRunning; }

    ClassDef(PngReader, 0)
};

#endif
