#ifndef STARCATALOG_H
#define STARCATALOG_H

#ifndef ROOT_TROOT
#include <TROOT.h>
#endif
#ifndef SAOFILE_H
#include "SaoFile.h"
#endif
#ifndef SLASTARS_H
#include "SlaStars.h"
#endif

#include "coord.h"

typedef unsigned char byte;

class MStarList;

class StarCatalog : public SlaStars
{
private:
    SaoFile *fSao;
    sort_t  *fSrt;
    int      fEntries;

    double   fPixSize;  // [rad/pix] size of one pixel
    double   fWidth;    // size of display
    double   fHeight;   //

    float    fLimitMag; // [M] limiting magnitude for display

    AltAz    fAltAz;    // [rad]
    byte     fAz0[360];
    int      fAltMin;
    int      fAltMax;
    int      fAzCnt;

    RaDec    fRaDec;    // [rad]
    byte     fRa0[360];
    int      fRaCnt;
    int      fDecMin;
    int      fDecMax;

    static void DrawCross(byte *img, const int x, const int y);
    static void DrawCircle(int color, byte *img, int xx, int yy, int size);

    Bool_t DrawAltAz(const int color, byte *img, double alt, double az,  int size=0) const;
    Bool_t DrawRaDec(const int color, byte *img, double ra,  double dec, int size=0) const;

    Bool_t Draw(const int color, byte *img, const AltAz &altaz);
    Bool_t Draw(const int color, byte *img, const RaDec &radec);

    //Bool_t Draw(const int color, byte *img, const SaoFile *sao);
    //void   CalcImg(byte *);

    void   CalcStars(MStarList &list) const;

    static void DrawStars(MStarList &list, byte *img);

    void   SetRaDec(const RaDec &radec);
    void   SetAltAz(const AltAz &altaz);
    void   DrawSCAltAz(byte *img, const int color) const;
    void   DrawSCRaDec(byte *img, const int color) const;
  
    void   CalcRaDecRange();
    void   CalcAltAzRange();

//    RaDec  AltAz2RaDec(const AltAz &altaz) const;
//    AltAz  RaDec2AltAz(const RaDec &radec, const RaDec &rdpm) const;

public:
    StarCatalog(MObservatory::LocationName_t key);
    virtual ~StarCatalog();

    void GetImg(byte *img, byte *cimg, MStarList &list) const;
    void GetImg(byte *img, byte *cimg, const double utc, const RaDec &radec);
    void GetImg(byte *img, byte *cimg, const double utc, const AltAz &altaz);

    void GetStars(MStarList &list, const double utc, const RaDec &radec);
    void GetStars(MStarList &list, const double utc, const AltAz &altaz);

    const AltAz GetAltAz() const { return fAltAz*kRad2Deg; }
    const ZdAz  GetZdAz() const  { return ZdAz(kPiDiv2-fAltAz.Alt(), fAltAz.Az())*kRad2Deg; }
    const RaDec GetRaDec() const { return fRaDec*kRad2Deg; }

    void  SetPixSize(const double pixsize);
    void  SetLimitMag(const float mag) { fLimitMag = mag; }

    double GetPixSize() const;

    AltAz CalcAltAzFromPix(Double_t pixx, Double_t pixy) const;

    ClassDef(StarCatalog, 0)
};

#endif
