#ifndef MGCOSY_H
#define MGCOSY_H

#ifndef ROOT_TGFrame
#include <TGFrame.h>
#endif

#ifndef MARS_MObservatory
#include "MObservatory.h"
#endif

#ifndef COSY_MStarList
#include "MStarList.h"
#endif

class TIterator;

class TGTab;
class TGLabel;
class TGMenuBar;
class TGTextView;
class TGPopupMenu;
class TGLayoutHints;
class TGCompositeFrame;
class TGHorizontal3DLine;

class ZdAz;
class RaDec;
class MsgQueue;

class MGList;
class MGImage;
class MGAccuracy;
class MGVelocity;
class MGCoordinates;
class MGSkyPosition;

class MGCosy : public TGMainFrame
{
private:
    const MObservatory::LocationName_t fObservatory;

    //
    // Create a main frame with a number of different buttons.
    //
    MGList        *fList;

    TGLabel       *fLabel1;
    TGLabel       *fLabel2;
    TGLabel       *fLabel3;

    TGLabel       *fOffsetZd;
    TGLabel       *fOffsetAz;

    TGLabel       *fRaEst;
    TGLabel       *fDecEst;

    TGLabel       *fRaSoll;
    TGLabel       *fDecSoll;

    TGLabel       *fZdSoll;
    TGLabel       *fAzSoll;

    TGLabel       *fUtc;
    TGLabel       *fMjd;

    MStarList     fStarList;

    MGCoordinates *fCZdAz;
    MGCoordinates *fCRaDec;
    MGCoordinates *fCCalib;

    MGSkyPosition *fSkyPosition;
    MGAccuracy    *fAccuracy;
    MGVelocity    *fVelocity;
    MGVelocity    *fOffset;

    MsgQueue      *fQueue;

    TGTab         *fTab;

    TGLabel *fError;
    TGLabel *fMoving;
    TGLabel *fTracking;
    TGLabel *fStopping;
    TGLabel *fStopped;
    TGLabel *fAvailMac1;
    TGLabel *fAvailMac2;
    TGLabel *fAvailMac3;
    TGLabel *fAvailSe1;
    TGLabel *fAvailSe2;
    TGLabel *fAvailSe3;

    TGTextView *fLog;

    FontStruct_t fFont;

    void CreateMenu();
    void CreateLabel(TGCompositeFrame *f);
    void CreateTabs(TGTab *fTab);
    void CreatePredefinedPos(TGCompositeFrame *tf1);

    void StartPos();
    void StartTrack();
    void StartTrackPos();
    void StartDemo();
    //void StartCalib();
    void StartTPoint();

    void EnableLabel(TGLabel *label, Bool_t stat);
    void SetLabelColor(TGLabel *label, Bool_t col);
    void UpdateOffset(ZdAz &off);
    void UpdateZdAz(ZdAz &off);
    void UpdateRaDec(ZdAz &pos, double mjd, RaDec &radec);
    double UpdateTime();

public:
    MGCosy(MObservatory::LocationName_t key, MsgQueue *q, const TGWindow *p, UInt_t w, UInt_t h);
    ~MGCosy();

    void CloseWindow();

    TGLabel *GetLabel1() const { return fLabel1; }
    TGLabel *GetLabel2() const { return fLabel2; }
    TGLabel *GetLabel3() const { return fLabel3; }

    TGTextView *GetLog() const { return fLog; }

    void Update(ZdAz pos, ZdAz acc, ZdAz vel, ZdAz off, RaDec radec, ZdAz soll, UInt_t stat, UInt_t stat2);

    Bool_t ProcessMessage(Long_t msg, Long_t mp1, Long_t mp2);

    ClassDef(MGCosy, 0)
};

#endif


