#include <TROOT.h>
#include <TApplication.h>

#include <iostream.h>

#include "Camera.h"
#include "PngReader.h"
#include "MStarguider.h"

/* ---------------------------------------------------------------------- */
//extern void InitGui();
//VoidFuncPtr_t initfuncs[] = { InitGui, 0 };

TROOT root("GUI", "GUI test environement"); //, initfuncs);

int main(int argc, char **argv)
{
    TApplication *app=new TApplication("Starguider", &argc, argv);

    Bool_t dummy = kFALSE;

    for (int i=0; i<argc; i++)
    {
        TString arg(argv[i]);
        if (arg=="-d")
            dummy = kTRUE;
    }

    PixClient *client=new MStarguider(MObservatory::kMagic1);
    PixGetter *get;

    if (dummy)
    {
        cout << " --> Starting in dummy-mode. <--" << endl;
        get=new PngReader(*client);
    }
    else
    {
        cout << " --> Starting in real-mode. <--" << endl;
        get = new Camera(*client);
        ((Camera*)get)->Loop(0);
    }

    app->Run(kTRUE);
    get->ExitLoop();

    delete get;
    delete client;

    cout << "Application end...." << endl;

    cout << "Exit." << endl;

    return 0;
}
