#ifndef SLALIB_H
#define SLALIB_H

#include <TROOT.h>

#include "coord.h"
#include "timer.h"
#include "MObservatory.h"

class Slalib : public Timer, public MObservatory
{
private:
    double fAlpha;

    static Double_t Round(Double_t val);
    static Double_t Trunc(Double_t val);

public:
    Slalib(MObservatory::LocationName_t key);
    virtual ~Slalib();

    static Double_t Hms2Sec(Int_t deg, UInt_t min, Double_t sec, char sgn='+');
    static Double_t Dms2Rad(Int_t deg, UInt_t min, Double_t sec, Char_t sgn='+');
    static Double_t Hms2Rad(Int_t hor, UInt_t min, Double_t sec, Char_t sgn='+');
    static Double_t Dms2Deg(Int_t deg, UInt_t min, Double_t sec, Char_t sgn='+');
    static Double_t Hms2Deg(Int_t hor, UInt_t min, Double_t sec, Char_t sgn='+');
    static Double_t Dms2Hor(Int_t deg, UInt_t min, Double_t sec, Char_t sgn='+');
    static Double_t Hms2Hor(Int_t hor, UInt_t min, Double_t sec, Char_t sgn='+');

    static void Day2Hms(Double_t rad, Char_t &sgn, UShort_t &deg, UShort_t &min, UShort_t &sec);
    static void Rad2Dms(Double_t rad, Char_t &sgn, UShort_t &deg, UShort_t &min, UShort_t &sec);
    static void Rad2Hms(Double_t rad, Char_t &sgn, UShort_t &deg, UShort_t &min, UShort_t &sec);
    static void Deg2Dms(Double_t rad, Char_t &sgn, UShort_t &deg, UShort_t &min, UShort_t &sec);
    static void Deg2Hms(Double_t rad, Char_t &sgn, UShort_t &deg, UShort_t &min, UShort_t &sec);
    static void Hor2Dms(Double_t rad, Char_t &sgn, UShort_t &deg, UShort_t &min, UShort_t &sec);
    static void Hor2Hms(Double_t rad, Char_t &sgn, UShort_t &deg, UShort_t &min, UShort_t &sec);

    static void Day2Hm(Double_t rad, Char_t &sgn, UShort_t &deg, Double_t &min);
    static void Rad2Dm(Double_t rad, Char_t &sgn, UShort_t &deg, Double_t &min);
    static void Rad2Hm(Double_t rad, Char_t &sgn, UShort_t &deg, Double_t &min);
    static void Deg2Dm(Double_t rad, Char_t &sgn, UShort_t &deg, Double_t &min);
    static void Deg2Hm(Double_t rad, Char_t &sgn, UShort_t &deg, Double_t &min);
    static void Hor2Dm(Double_t rad, Char_t &sgn, UShort_t &deg, Double_t &min);
    static void Hor2Hm(Double_t rad, Char_t &sgn, UShort_t &deg, Double_t &min);

    virtual void SetMjd(double mjd);

    double GetAlpha() const  { return fAlpha; }

    ZdAz   XYZ2ZdAz(double coord[3]) const;

    ClassDef(Slalib, 0)
};

#endif
