#include "Led.h"

#include <iostream.h>

#include <TROOT.h>
#include <TMath.h>

#include "Ring.h"

ClassImp(Led);

void Led::CalcPhi(const Ring &ring)
{
    fPhi = TMath::ATan2(fY-ring.GetY(), fX-ring.GetX())*180/TMath::Pi();
}

void Led::Print(Option_t *o=NULL) const
{
    cout << "Led: ";
    cout << "x="   << Form("%5.1f", fX)   << "+-" << fDx   << ", ";
    cout << "y="   << Form("%5.1f", fY)   << "+-" << fDy   << ", ";
    cout << "phi=" << Form("%6.1f", fPhi) << "+-" << fDphi << ", ";
    cout << "mag=" << fMag << endl;
}
