#ifndef CAOS_FilterLed
#define CAOS_FilterLed

#ifndef __CINT__
#include <TROOT.h>
#endif

typedef unsigned char byte;

class Led;
class Leds;
class Ring;

class FilterLed
{
    byte *fImg;
    int fW;
    int fH;
    int fBoxW;
    int fBoxH;
    float fCut;

    void GetMinMax(const int offset, byte *min, byte *max) const;
    int  GetMeanPosition(const int x, const int y, const int box) const;
    int  GetMeanPosition(const int x, const int y, const int box, float &mx, float &my) const;
    void RemoveTwinsInterpol(Leds &leds, Int_t first, Double_t radius) const;
    void DrawBox(const int x1, const int y1,
                 const int x2, const int y2,
                 const int col) const;

public:
    FilterLed(byte *img, int w, int h, double cut=2.5)
        : fImg(img), fW(w), fH(h), fBoxW(w/2), fBoxH(h/2), fCut(cut)
    {
    }

    FilterLed(byte *img, int w, int h, int box, double cut=2.5)
        : fImg(img), fW(w), fH(h), fBoxW(box), fBoxH(box), fCut(cut)
    {
    }

    FilterLed(byte *img, int w, int h, int boxw, int boxh, double cut=2.5)
        : fImg(img), fW(w), fH(h), fBoxW(boxw), fBoxH(boxh), fCut(cut)
    {
    }

    void Execute(Leds &leds, int xc, int yc) const;
    void Execute(Leds &leds) const { Execute(leds, fW/2, fH/2); }
    void ExecuteAndMark(Leds &leds, int xc, int yc) const;
    void ExecuteAndMark(Leds &leds) const { ExecuteAndMark(leds, fW/2, fH/2); }
    void Execute(int xc, int yc) const;
    void Execute() const { Execute(fW/2, fH/2); }
    void MarkPoint(const Led &led) const;
    void MarkPoint(Float_t x, Float_t y, Float_t mag) const;
    void Stretch() const;
    void DrawCircle(float cx, float cy, float r, byte col=0x40) const;
    void DrawCircle(float r, byte col=0x40) const { DrawCircle(r, fW/2.+.5, fH/2.+.5, col); }
    void DrawCircle(const Ring &c, byte col=0x40) const;
    void DrawCircle(const Ring &c, double r, byte col) const;

    ClassDef(FilterLed, 0)
};

#endif
