#ifndef MSGQUEUE_H
#define MSGQUEUE_H

#include "threads.h"

#define WM_NULL 0x0000
#define WM_QUIT 0xffff

#ifndef ROOT_TMutex
#include <TMutex.h>
#endif

class MsgQueue
{
private:
    int fBreak;
    int fStart;
    int fStop;

    int fMsg;     // Message identifier
    void *fMp;    // Message Parameter
    void *fSize;  // Message Parameter Size
    void *fRc;    // Proc return code

    pthread_t fThread;
    TMutex    fMuxMsg;

    static void *MapThread(void *arg);

    void Thread();

public:
    MsgQueue();
    virtual ~MsgQueue();

    int Break() const { return fBreak; }

    virtual void *Proc(int msg, void *mp1);
    void *Proc(int msg) { return Proc(msg, 0); }

    void *PostMsg(int msg, void *mp1, int size);
    void *PostMsg(int msg) { return PostMsg(msg, 0, 0); }
};

#endif
