#ifndef COSY_MStar
#define COSY_MStar

#include <TObject.h>

class MStar : public TObject
{
private:
    Double_t fX;
    Double_t fY;

    Double_t fMag;

public:
    MStar(Double_t x=0, Double_t y=0, Int_t m=0) : fX(x), fY(y), fMag(m) {}
    MStar(const MStar &p) { fX = p.fX; fY=p.fY; fMag=p.fMag; }
    Double_t GetX() const   { return fX; }
    Double_t GetY() const   { return fY; }
    Double_t GetMag() const { return fMag; }

    void Set(Double_t mx, Double_t my) { fX=mx; fY=my; }

    Int_t Compare(const TObject *obj) const
    {
        const MStar *const s = (MStar*)obj;

        if (fMag<s->fMag)
            return -1;

        if (fMag>s->fMag)
            return 1;

        return 0;
    }

    Bool_t IsSortable() const { return kTRUE; }


    ClassDef(MStar, 1)
};

#endif
