/*-----------------------------------------------------------------------------
dbtm.h -- DBT Master Interface

Copyright (c) 1994 JANZ Computer AG
All Rights Reserved

Created 95/02/23 by Soenke Hansen
Version 1.7 of 96/05/21

Prototype declarations of functions defined in dbtm.c.

-----------------------------------------------------------------------------*/

#ifndef dbtm_DEFINED
#define dbtm_DEFINED

#ifdef __cplusplus
extern "C" {
#endif

#include "defs.h"
#include "msg.h"
#include "cal.h"


/*--------- Data structures of COB database ---------------------------------*/

/* User Definition */
struct usrdef {
	WORD_t		id;	/* COB-ID */
	BYTE_t		nid;	/* node Id */
	BYTE_t		len;	/* COB length */
	BYTE_t		type;	/* COB type */
	BYTE_t		cclass; /* COB class */
	WORD_t		inht;	/* actual inhibit time */
	BYTE_t		cobnm[COB_NAME_LEN];	/* COB name */
	struct usrdef	*next;	/* next in same COB definition */
};

/* Pre-Definition */
struct predef {
	WORD_t		id;	/* COB-ID */
	BYTE_t		cobnm[COB_NAME_LEN];	/* COB name */
	struct predef	*next;	/* next in same COB definition */
};

/* COB Definition */
struct cobdef {
	WORD_t		id;	/* COB-ID */
	WORD_t		inht;	/* inhibit time */
	struct usrdef	*usr;	/* list of user definitions */
	struct predef	*pre;	/* list of pre-definitions */
};


/* State of COB database */
extern int CobDBEnabled;

/*--------- COB Database Functions ------------------------------------------*/

/* Create COB Database Service (initialization of DB) */
extern void CreateCobDB(void);

/* Set state of COB database to ENABLED */
extern void EnableDist(void);

/* Set state of COB database to DISABLED */
extern void DisableDist(void);

/* Create COB Definition Service */
extern int CreateCobDef(
	WORD_t,	/* lower bound of COB-ID range */
	WORD_t,	/* upper bound of COB-ID range */
	WORD_t	/* minimum inhibit time */
);

/* Delete COB Definition Service */
extern void DeleteCobDef(
	WORD_t,	/* lower bound of COB-ID range */
	WORD_t	/* upper bound of COB-ID range */
);

/* Create Pre-Definition Service */
extern int CreatePreDef(
	WORD_t,		/* COB ID */
	BYTE_t	*	/* COB name */
);

/* Delete Pre-Definition Service */
extern void DeletePreDef(
	BYTE_t	*	/* COB name */
);


/* Get next COB Definition in database. */
extern struct cobdef *GetNextCobDef(int);

/* Get next User Definition in database. */
extern struct usrdef *GetNextUsrDef(int);

/* Get next COB Definition in database. */
extern struct predef *GetNextPreDef(int);


/*--------- Creation, Initialization, Destruction ---------------------------*/

/* Create and initialize the DBT Master */
extern void InitDbtM(
	WORD_t		/* timeout interval */
);

void ConfigDbtM(
	WORD_t		timeout,	/* timeout interval */
	WORD_t		flags		/* various config. flags */
);

/* Remove the DBT Master. Free the resources it holds. */
extern void DeleteDbtM(void);


#ifdef __cplusplus
}
#endif

#endif /* !dbtm_DEFINED */
