#ifndef STARCATALOG_H
#define STARCATALOG_H

#ifndef ROOT_TROOT
#include <TROOT.h>
#endif
#ifndef ROOT_GuiTypes
#include <GuiTypes.h>
#endif
#ifndef SAOFILE_H
#include "SaoFile.h"
#endif
#ifndef SLASTARS_H
#include "SlaStars.h"
#endif

#include "coord.h"

typedef unsigned char byte;

class MStarList;
class MAstroCatalog;

class StarCatalog : public SlaStars
{
private:

    int fW;
    int fH;

 
    MAstroCatalog *fAstro;

    double   fPixSize;  // [rad/pix] size of one pixel
    double   fSinAngle;
    double   fCosAngle;

    float    fLimitMag; // [M] limiting magnitude for display

    AltAz    fAltAz;    // [rad]
    RaDec    fRaDec;    // [rad]

    static void DrawCross(byte *img, const int x, const int y);
    static void DrawCircle(int color, byte *img, int xx, int yy, int size);

    void   SetRaDec(const RaDec &radec);
    void   SetAltAz(const AltAz &altaz);

    int    fBox;

public:
    StarCatalog(MObservatory::LocationName_t key);
    virtual ~StarCatalog();

    void GetImg(byte *img, byte *cimg, MStarList &list) const;
    void PaintImg(unsigned char *buf, int w, int h);

    const AltAz GetAltAz() const /*[deg]*/ { return fAltAz*kRad2Deg; }
    const ZdAz  GetZdAz() const  /*[deg]*/ { return ZdAz(kPiDiv2-fAltAz.Alt(), fAltAz.Az())*kRad2Deg; }
    const RaDec GetRaDec() const /*[deg]*/ { return fRaDec*kRad2Deg; }

    void  SetPixSize(const double pixsize);
    void  SetLimitMag(const float mag);
    void  SetRotationAngle(const float angle) { fSinAngle = sin(angle/kRad2Deg); fCosAngle = cos(angle/kRad2Deg); }
    void  Reload();

    double GetPixSize() const;

    AltAz CalcAltAzFromPix(Double_t pixx, Double_t pixy) const;

    virtual void SetMjd(double mjd);

    void SetPointing(double mjd, const RaDec &radec)
    {
        SetMjd(mjd); SetRaDec(radec);
    }

    void   CalcStars(MStarList &list, int xc, int yc, int xo, int yo) const;
    void   CalcStars(MStarList &list);
    static void DrawStars(MStarList &list, byte *img);

    void SetBox(int box)   { fBox = box; }

    ClassDef(StarCatalog, 0)
};

#endif
