#include "Led.h"

#include <iostream>

#include <TROOT.h>
#include <TMath.h>

#include "Ring.h"
#include "MString.h"

ClassImp(Led);

using namespace std;

void Led::CalcPhi(const Ring &ring)
{
    fPhi = TMath::ATan2(fY-ring.GetY(), fX-ring.GetX())*180/TMath::Pi();
}

void Led::Print(Option_t *o) const
{
    MString str;
    cout << "Led: ";
    cout << "x="   << str.Print("%5.1f", fX)   << "+-" << fDx   << ", ";
    cout << "y="   << str.Print("%5.1f", fY)   << "+-" << fDy   << ", ";
    cout << "phi=" << str.Print("%6.1f", fPhi) << "+-" << fDphi << ", ";
    cout << "mag=" << fMag << endl;
}
