#include "File.h"

#include <stdlib.h>

File::File(const char *name, const char *flags)
{
    f = fopen(name, flags);
    if (!f)
        printf("WARNING: Cannot open '%s'\n", name);
}

File::~File()
{
    if (f)
        fclose(f);
}

char File::Getc() const
{
    return fgetc(f);
}

int File::Eof() const
{
    return feof(f);
}

void File::Seek(long pos) const
{
    fseek(f, pos, SEEK_SET);
}

void File::Reset() const
{
    fseek(f, 0, SEEK_SET);
}

long File::Tell() const
{
    return ftell(f);
}

long File::Size() const
{
    long l = ftell(f);
    fseek(f, 0, SEEK_END);
    long s = ftell(f);
    fseek(f, l, SEEK_SET);
    return s;
}

char *File::Gets(char *c, int cnt) const
{
    for (int i=0; i<cnt; i++)
        *c++=fgetc(f);
    *c='\0';

    return c;
}

void File::Newline() const
{
    int g;
    do g=fgetc(f);
    while (g!=0x0A && g!=EOF);
}

int File::Geti(int cnt) const
{
    char *c = new char[cnt+1];
    Gets(c, cnt);
    int result = atoi(c);
    delete c;
    return result;
}

float File::Getf(int cnt) const
{
    char *c = new char[cnt+1];
    Gets(c, cnt);
    float result = atof(c);
    delete c;
    return result;
}

void File::Skip(int cnt) const
{
    char *c = new char[cnt+1];
    Gets(c, cnt);
    delete c;
}

