#ifndef COSY_MGCoordinates
#define COSY_MGCoordinates

//
// This File contains the declaration of the MGCoordinates-class
//
//   Author: Thomas Bretz
//   Version: V1.0 (1-8-2000)

#ifndef ROOT_TGFrame
#include <TGFrame.h>
#endif

class XY;

enum {
    kETypeZdAz = BIT(0),
    kETypeRaDec= BIT(1),
    kETypeNone = BIT(3)
};

class MGCoordinate;

class MGCoordinates : public TGFrame
{
    MGCoordinate *fX;
    MGCoordinate *fY;

public:
    MGCoordinates(const TGWindow* p, const Int_t type=kETypeZdAz,
                  const Int_t flag=1,
                  const Int_t deg1=0, const UInt_t min1=0, const UInt_t sec1=0,
                  const Int_t deg2=0, const UInt_t min2=0, const UInt_t sec2=0);
    ~MGCoordinates();

    XY   GetCoordinates() const;
    void SetCoordinates(const XY &xy);

    void Print();

    ClassDef(MGCoordinates, 0)
};

#endif // COSY_MGCoordinates
