#ifndef MGSTARGUIDER_H
#define MGSTARGUIDER_H

#ifndef ROOT_TGFrame
#include <TGFrame.h>
#endif
#ifndef CAMERA_H
#include "Camera.h"
#endif

#include "MGList.h"
#include "MGImage.h"

class RaDec;

class TGMenuBar;
class TGPopupMenu;
class TGTextEntry;

class MGImage;
class MGCoordinates;

class StarCatalog;

class MGStarguider : public Camera, public TGMainFrame
{
private:
    MGList        *fList;

    TGMenuBar     *fMenu;
    MGImage       *fImage;

    TGPopupMenu   *fDisplay;
    TGPopupMenu   *fWrite;
    TGPopupMenu   *fFileType;
    TGPopupMenu   *fWriteType;
    TGPopupMenu   *fWriteRate;
    TGPopupMenu   *fSetup;
    TGPopupMenu   *fLimMag;

    MGCoordinates *fCRaDec;
    MGCoordinates *fCZdAz;

    TGTextEntry   *fPixSize;

    StarCatalog   *fSao;

    RaDec *fRaDec;

    int fWrtRate;

    void SetPixSize(const double pixsize);
    void Toggle(TGPopupMenu *p, UInt_t id);
    void GetCoordinates();

public:
    MGStarguider();
    virtual ~MGStarguider();

    //void Update();

    void Layout();
    void CloseWindow();

    Bool_t ProcessMessage(Long_t msg, Long_t parm1, Long_t parm2);

    //
    // Execution of one frame - this function may be overloaded!
    //
    void ProcessFrame(const unsigned long n, byte *img, struct timeval *tm);

    ClassDef(MGStarguider, 0)
};

#endif
