//
// This File contains the definition of the MGCoordinates-class
//
//   Author: Thomas Bretz
//   Version: V1.0 (1-8-2000)

#include "MGCoordinates.h"

#include <iostream.h>  // cout

#include "MGCoordinate.h"

MGCoordinates::MGCoordinates(const TGWindow* p,
                             const Bool_t flag,
                             const char *txt1, const char *txt2,
                             const Int_t deg1, const UInt_t min1, const UInt_t sec1,
                             const Int_t deg2, const UInt_t min2, const UInt_t sec2)
: TGFrame(p, 234, 76, kFixedSize)
{
    // p = pointer to MainFrame (not owner)
    fX = new MGCoordinate(this, flag, txt1, deg1, min1, sec1);
    fX->Move(0, 0);

    fY = new MGCoordinate(this, flag, txt2, deg2, min2, sec2);
    fY->Move(120, 0);

    MapWindow();
}

MGCoordinates::~MGCoordinates()
{
    delete fY;
    delete fX;

    cout << "MGCoordinates destroyed." << endl;
}

XY MGCoordinates::GetCoordinates() const
{
    return XY(fX->GetVal(), fY->GetVal());
}

void MGCoordinates::SetCoordinates(const XY &xy)
{
    fX->SetVal(xy.X());
    fY->SetVal(xy.Y());
}

void MGCoordinates::Print()
{
    fX->Print();
    fY->Print();
}
