/* ======================================================================== *\
!
! *
! * This file is part of Stesy, the MAGIC Steering System
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz 1/2008 <mailto:tbretz@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2008
!
!
\* ======================================================================== */

///////////////////////////////////////////////////////////////////////
//
// Interface
//
// Class describing the interface to the Janz card in RawCan mode.
//
///////////////////////////////////////////////////////////////////////
#include "interface.h"

#include <sys/time.h>      // gettimeofday

#include "MLog.h"
#include "MLogManip.h"

#include "canopen.h"

//ClassImp(Interface);

using namespace std;

Interface::Interface(CanOpen *rx) : fReceiver(rx)
{
    fReceiver->SetInterface(this);
}

Interface::~Interface()
{
    gLog << inf2 << " - Interface::~Interface()" << endl;
    fReceiver->SetInterface(NULL);
}

void Interface::HandleMessage(const Message &msg) const
{
    if (fReceiver)
        return;

    //
    // read the time for the message as soon as possible
    //
    timeval_t tv;
    gettimeofday(&tv, NULL);

    fReceiver->HandleMessage(msg, tv);
}

// --------------------------------------------------------------------------
//
// Prints a CAN Message.
//
void Interface::PrintMsg(const Message &m)
{
    cout << "Cmd=0x" << hex << (int)m.cmd << dec << " " << flush;
    cout << "len=" << (int)m.len << ":" << flush;

    cout << hex << flush;
    for (int i=0; i<m.len; i++)
        cout << " " << (int)m.data[i] << flush;
    cout << dec << endl;
}
