#ifndef COSY_Interface
#define COSY_Interface

#ifdef __CINT__
//#include <TROOT.h>
typedef UShort_t WORD_t;
typedef Byte_t   BYTE_t;
struct Message;
struct FastMessage;
#else
#include "gendef.h"
#include "dpm.h"
#endif

typedef struct timeval timeval_t;

class CanOpen;

class Interface
{
private:
    CanOpen *fReceiver;

protected:
    Interface(CanOpen *rx);

    // Interface to receiver
    void HandleMessage(const Message &msg) const;

    // Helper for SendCanFrame
    WORD_t MsgDescr(const WORD_t cobid, const BYTE_t dlc, const BYTE_t rtr=0)
    {
        return (cobid<<5) | ((rtr&0x1)<<4) | (dlc&0xf);
    }

public:
    virtual ~Interface();

    // Start/stop communication
    virtual void Start() = 0; /*{ RunThread();    }*/
    virtual void Stop()  = 0; /*{ CancelThread(); }*/

    // Public transmit interface
    virtual void SendCanFrame(WORD_t cobid, BYTE_t m[8], BYTE_t rtr) = 0;
    virtual void EnableCobId(WORD_t cobid, int flag=TRUE) { }

    // Public interface
    void PrintMsg(const Message &m);
};

#endif
