#ifndef NETWORK_H
#define NETWORK_H

#include "canopen.h"
#include "nodedrv.h"

class Network : public CanOpen
{
private:
    NodeDrv *fNodes[32];
    int fNodeInitialized[32];

    void HandleSDO(BYTE_t node, BYTE_t cmd, WORD_t idx, BYTE_t subidx, LWORD_t data, struct timeval *tv);
    void HandlePDO1(BYTE_t node, BYTE_t *data, struct timeval *tv);
    void HandlePDO2(BYTE_t node, BYTE_t *data, struct timeval *tv);
    void HandlePDO3(BYTE_t node, BYTE_t *data, struct timeval *tv);
    void HandlePDO4(BYTE_t node, BYTE_t *data, struct timeval *tv);

    void InitNodes();
    void StopNodes();

public:
    Network(const char *dev, const int baud, ostream &out=cout);

    void SetNode(NodeDrv *drv);

    NodeDrv *operator[](int i) { return fNodes[i]; }
    NodeDrv *GetNode(int i)    { return fNodes[i]; }

    virtual void Start();
    virtual void Stop();

    bool HasError();
};

#endif
