#ifndef MGCOSY_H
#define MGCOSY_H

#ifndef ROOT_TGFrame
#include <TGFrame.h>
#endif

//#ifndef ROOT_TOrdCollection
//#include <TOrdCollection.h>
//#endif

#ifndef ROOT_TGWidget
#include <TGWidget.h>
#endif

#include <iostream.h>

#include "coord.h"

class TGLabel;
class TGPopupMenu;
class TGMenuBar;
class TGHorizontal3DLine;
class TGLayoutHints;
class MsgQueue;
class TIterator;
class MGImage;
class MGList;
class MGCoordinates;
class MGSkyPosition;
class MGAccuracy;
class MGVelocity;
class TGCompositeFrame;
class TGTab;
class TGListBox;

class MGCosy : public TGMainFrame
{
private:

    //
    // Create a main frame with a number of different buttons.
    //
    TGLayoutHints *fLayMenuBar;
    TGLayoutHints *fLayMenuItem;

    MGList        *fList;

    TGLabel      **fLabel1;
    TGLabel      **fLabel2;
    TGLabel      **fLabel3;

    TGLabel       *fOffsetZd;
    TGLabel       *fOffsetAz;

    MGCoordinates *fCoord;
    MGSkyPosition *fSkyPosition;
    MGAccuracy    *fAccuracy;
    MGVelocity    *fVelocity;
    MGVelocity    *fOffset;

    MsgQueue      *fQueue;

    TGTab         *fTab;

    TGLabel *fError;
    TGLabel *fMoving;
    TGLabel *fTracking;
    TGLabel *fStopping;
    TGLabel *fStopped;

    TGListBox *fLog;

    void CreateMenu();
    void CreateLabel(TGCompositeFrame *f);
    void CreateButton(TGCompositeFrame *tf1, TGCompositeFrame *tf2);

    void Start(UInt_t id);

    void EnableLabel(TGLabel *label, Bool_t stat);
    void UpdateOffset(ZdAz &off);

public:
    MGCosy(MsgQueue *q, const TGWindow *p, UInt_t w, UInt_t h);
    ~MGCosy();

    void CloseWindow();

    TGLabel **GetLabel1() const { return fLabel1; }
    TGLabel **GetLabel2() const { return fLabel2; }
    TGLabel **GetLabel3() const { return fLabel3; }

    TGListBox *GetLog() const { return fLog; }

    void Update(ZdAz pos, ZdAz acc, ZdAz vel, ZdAz off, UInt_t stat);

    Bool_t ProcessMessage(Long_t msg, Long_t mp1, Long_t mp2);
};

#endif


