#ifndef COSY_MTracking
#define COSY_MTracking

#ifndef COSY_MSlewing
#include "MSlewing.h"
#endif

#ifndef COSY_SlaPlanets
#include "SlaPlanets.h"
#endif

#ifndef MARS_MThread
#include "MThread.h"
#endif

class MLog;
class RaDec;
class SlaStars;

class MTracking : public MSlewing, public MThread
{
private:
    SlaPlanets fSlalib;

    ZdAz fTrackAcc;

    Int_t fTrackType;
    RaDec fTrackPos;

    MLog   *fOut;

    void UpdateSlalib(SlaPlanets &sla);
    void UpdateSlalib(Double_t dt=0);
    void UpdateSlalib(SlaPlanets &sla, Double_t mjd);

    bool SetVelocity(const ZdAz &v);
    bool LimitSpeed(const ZdAz &vt) const;
    bool InitTracking();
    bool Move();
    void Track();

    Int_t Thread();

public:
    MTracking(MCosy *cosy);

    void TrackPosition(const RaDec &dst); // ra, dec [rad]
    void TrackPlanet(ePlanets_t planet);  // ra, dec [rad]
    void SetTrackAcc(Float_t zd, Float_t az) { fTrackAcc.Zd(zd); fTrackAcc.Az(az); }

    void SetOut(MLog *fout) { fOut = fout; }

    ClassDef(MTracking, 0)
};

#endif
