/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Daniela Dorner, 01/2005 <mailto:dorner@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2006
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
// fillsources.C
// ============
//
// Returns 0 in case of failure and 1 in case of success.
//
/////////////////////////////////////////////////////////////////////////////

#include <iostream>
#include <iomanip>
#include <fstream>

#include <TSQLRow.h>
#include <TSQLResult.h>

#include "MSQLServer.h"

using namespace std;

Bool_t ExistStr(MSQLServer &serv, const char *column, const char *table, const char *test)
{
    TString query(Form("SELECT %s FROM %s WHERE %s='%s'", column, table, column, test));

    cout << "query: " << query << endl;

    TSQLResult *res = serv.Query(query);
    if (!res)
        return kFALSE;

    Bool_t rc = kFALSE;

    TSQLRow *row=res->Next();
    if (row && (*row)[0])
        rc=kTRUE;

    delete res;
    return rc;
}


int fillsources(TString catalog)
{
    MSQLServer serv("sql.rc");
    if (!serv.IsConnected())
    {
        cout << "ERROR - Connection to database failed." << endl;
        return 0;
    }
    cout << "insertdate" << endl;
    cout << "----------" << endl;
    cout << endl;
    cout << "Connected to " << serv.GetName() << endl;
    cout << endl;

    TString source;
    TString RA;
    TString Dec;
    TString waste;
    ifstream fin(catalog);
    if (!fin)
    {
        cout << "Could not open file " << catalog << endl;
        return 0;
    }

    while (1)
    {
        if (!fin)
            break;

        source.ReadToDelim(fin, ',');
        waste.ReadToDelim(fin, ',');
        RA.ReadToDelim(fin, ',');
        Dec.ReadToDelim(fin, ',');
        waste.ReadToDelim(fin, '\n');

        cout << "source: " << source << endl;
        cout << "RA: " << RA << endl;
        cout << "Dec: " << Dec << endl;

        //insert entry for date into the table SequenceBuildStatus,
        // if entry is not yet existing
        if (!ExistStr(serv, "fSourceName", "Source", source))
        {
            TString query(Form("INSERT Source SET fSourceName='%s', fRightAscension='%s', fDeclination='%s' ",
                               source.Data(), RA.Data(), Dec.Data()));

            cout << "query: " << query << endl;
            /*
             TSQLResult *res = serv.Query(query);
             if (!res)
             {
             cout << "Error - could not insert entry" << endl;
             return 0;
             }
             delete res;
             */
        }
        else
        {
            cout << source << " already exists... do update. " << endl;

            TString query(Form("Update Source SET fRightAscension='%s', fDeclination='%s' WHERE fSourceName='%s',",
                               RA.Data(), Dec.Data(), source.Data()));

            cout << "query: " << query << endl;
            /*
             TSQLResult *res = serv.Query(query);
             if (!res)
             {
             cout << "Error - could not update entry" << endl;
             return 0;
             }
             delete res;*/
        }
    }

    return 1;
}


