<?php

$needs = array
    (
     "fCCFilled"             => "SequenceBuildStatus.fDate",
     "fExclusionsDone"       => "fCCFilled",
     "fSequenceEntriesBuilt" => "fExclusionsDone",
     "fCCFileAvail"          => "RunProcessStatus.fRunNumber",
     "fCaCoFileAvail"        => "RunProcessStatus.fRunNumber",
     "fCaCoFileFound"        => "RunProcessStatus.fRunNumber",
     "fRawFileAvail"         => "RunProcessStatus.fRunNumber",
     "fDataCheckDone"        => "fRawFileAvail",
     "fTimingCorrection"     => "fRawFileAvail",
     "fSequenceFileWritten"  => "SequenceProcessStatus.fSequenceFirst",
     "fAllFilesAvail"        => "fSequenceFileWritten",
     "fCallisto"             => "fAllFilesAvail",
     "fStar"                 => "fCallisto",
     "fFillCallisto"         => "fCallisto",
     "fFillStar"             => "fStar",
     "fDataSetInserted"      => "DataSetProcessStatus.fDataSetNumber",
     "fDataSetFileWritten"   => "fDataSetInserted",
     "fStarFilesAvail"       => "fDataSetFileWritten",
     "fGanymed"              => "fStarFilesAvail",
     "fFillGanymed"          => "fGanymed",
     );


$limitsmean = array
    (
     "fPedRmsInLimit"    => "fMeanPedRmsInner",
//     "fArrTRmsLimit"     => "fArrTimeRmsInner",
     "fMuonRateLimit"    => "fMuonRate",
     "fMuonCalLimit"     => "fRatio",
     "fPSFLimit"         => "fPSF",
     "fInhomLimit"       => "fInhomogeneity",
     "fNumIslLimit"      => "fMeanNumberIslands",
     "fImgRateLimit"     => "fDataRate",
     "fSkyBrightLimit"   => "fBrightnessMed",
    );

$limitsmin = array
    (
     "fZdMinLimit"       => "fZenithDistanceMin",
     "fNumStarsLimit"    => "fNumStarsMed",
     "fNumStarsCorLimit" => "fNumStarsCorMed",
     "fMuonNumLimit"     => "fMuonNumber",
//     "fArrTimeLimit"     => "fArrTimeInner",
     "fPulsePosLimit"    => "fMeanPulsePosInner",
     "fRunTimeLimit"     => "fRunTime/60",
     "fRelTimeMinLimit"  => "fEffOnTime/fRunTime",
    );

$limitsmax = array
    (
     "fZdMaxLimit"       => "fZenithDistanceMax",
     "fUnsInLimit"       => "fUnsuitableInner",
     "fIsoInLimit"       => "fIsolatedInner",
     "fIMCLimit"         => "fIsolatedMaxCluster",
     "fMaxHumLimit"      => "fMaxHumidity",
     "fRelTimeMaxLimit"  => "fEffOnTime/fRunTime",
    );

$checkwhere = array
    (
     "fRunTypeName"                      => CheckWhere("fRunTypeKEY",                      $_GET),
     "fProjectName"                      => CheckWhere("fProjectKEY",                      $_GET),
     "fSourceName"                       => CheckWhere("fSourceKEY",                       $_GET),
     "fMagicNumberName"                  => CheckWhere("fMagicNumberKEY",                  $_GET),
     "fL1TriggerTableName"               => CheckWhere("fL1TriggerTableKEY",               $_GET),
     "fL2TriggerTableName"               => CheckWhere("fL2TriggerTableKEY",               $_GET),
     "fHvSettingsName"                   => CheckWhere("fHvSettingsKEY",                   $_GET),
     "fCalibrationScriptName"            => CheckWhere("fCalibrationScriptKEY",            $_GET),
     "fExcludedFDAName"                  => CheckWhere("fExcludedFDAKEY",                  $_GET),
     "fManuallyChangedName"              => CheckWhere("fManuallyChangedKEY",              $_GET),
     "fObservationModeName"              => CheckWhere("fObservationModeKEY",              $_GET),
     "fDiscriminatorThresholdTableName"  => CheckWhere("fDiscriminatorThresholdTableKEY",  $_GET),
     "fTriggerDelayTableName"            => CheckWhere("fTriggerDelayTableKEY",            $_GET),
     "fTestFlagName"                     => CheckWhere("fTestFlagKEY",                     $_GET),
     "fLightConditionsName"              => CheckWhere("fLightConditionsKEY",              $_GET),
     "fParticleTypeName"                 => CheckWhere("fParticleTypeKEY",                 $_GET),
     "fFitsFileName"                     => CheckWhere("fFitsFileKEY",                     $_GET),
     "fObjectName"                       => CheckWhere("fObjectKEY",                       $_GET),
     "fStatusName"                       => CheckWhere("fStatusKEY",                       $_GET),
     "fTelescopeName"                    => CheckWhere("fTelescopeKEY",                    $_GET),
     "fBandName"                         => CheckWhere("fBandKEY",                         $_GET),
     "fUserName"                         => CheckWhere("fUserKEY",                         $_GET),
    );

$checkgroup = array
    (
     "fRunTypeName"                      => CheckGroup("fRunTypeKEY",                      $_GET),
     "fProjectName"                      => CheckGroup("fProjectKEY",                      $_GET),
     "fSourceName"                       => CheckGroup("fSourceKEY",                       $_GET),
     "fMagicNumberName"                  => CheckGroup("fMagicNumberKEY",                  $_GET),
     "fL1TriggerTableName"               => CheckGroup("fL1TriggerTableKEY",               $_GET),
     "fL2TriggerTableName"               => CheckGroup("fL2TriggerTableKEY",               $_GET),
     "fHvSettingsName"                   => CheckGroup("fHvSettingsKEY",                   $_GET),
     "fCalibrationScriptName"            => CheckGroup("fCalibrationScriptKEY",            $_GET),
     "fExcludedFDAName"                  => CheckGroup("fExcludedFDAKEY",                  $_GET),
     "fManuallyChangedName"              => CheckGroup("fManuallyChangedKEY",              $_GET),
     "fObservationModeName"              => CheckGroup("fObservationModeKEY",              $_GET),
     "fDiscriminatorThresholdTableName"  => CheckGroup("fDiscriminatorThresholdTableKEY",  $_GET),
     "fTriggerDelayTableName"            => CheckGroup("fTriggerDelayTableKEY",            $_GET),
     "fTestFlagName"                     => CheckGroup("fTestFlagKEY",                     $_GET),
     "fLightConditionsName"              => CheckGroup("fLightConditionsKEY",              $_GET),
     "fParticleTypeName"                 => CheckGroup("fParticleTypeKEY",                 $_GET),
     "fFitsFileName"                     => CheckGroup("fFitsFileKEY",                     $_GET),
     "fObjectName"                       => CheckGroup("fObjectKEY",                       $_GET),
     "fStatusName"                       => CheckGroup("fStatusKEY",                       $_GET),
     "fBandName"                         => CheckGroup("fBandKEY",                         $_GET),
     "fUserName"                         => CheckGroup("fUserKEY",                         $_GET),
     "fTelescopeName"                    => CheckGroup("fTelescopeKEY",                    $_GET),
    );


$checkstatusgroup = array
    (
     "fCCFilled"                         => CheckStatusGroup("fCCFilledStatus",            $_GET),
     "fExclusionsDone"                   => CheckStatusGroup("fExclusionsDoneStatus",      $_GET),
     "fSequenceEntriesBuilt"             => CheckStatusGroup("fSequenceEntriesBuiltStatus",$_GET),
     "fCCFileAvail"                      => CheckStatusGroup("fCCFileAvailStatus",         $_GET),
     "fCaCoFileAvail"                    => CheckStatusGroup("fCaCoFileAvailStatus",       $_GET),
     "fCaCoFileFound"                    => CheckStatusGroup("fCaCoFileFoundStatus",       $_GET),
     "fRawFileAvail"                     => CheckStatusGroup("fRawFileAvailStatus",        $_GET),
     "fTimingCorrection"                 => CheckStatusGroup("fTimingCorrectionStatus",    $_GET),
     "fDataCheckDone"                    => CheckStatusGroup("fDataCheckDoneStatus",       $_GET),
//     "fFillDotRaw"                       => CheckStatusGroup("fFillDotRawStatus",          $_GET),
     "fSequenceFileWritten"              => CheckStatusGroup("fSequenceFileWrittenStatus", $_GET),
     "fAllFilesAvail"                    => CheckStatusGroup("fAllFilesAvailStatus",       $_GET),
     "fCallisto"                         => CheckStatusGroup("fCallistoStatus",            $_GET),
     "fFillCallisto"                     => CheckStatusGroup("fFillCallistoStatus",        $_GET),
     "fStar"                             => CheckStatusGroup("fStarStatus",                $_GET),
     "fFillStar"                         => CheckStatusGroup("fFillStarStatus",            $_GET),
     "fDataSetInserted"                  => CheckStatusGroup("fDataSetInsertedStatus",     $_GET),
     "fDataSetFileWritten"               => CheckStatusGroup("fDataSetFileWrittenStatus",  $_GET),
     "fStarFilesAvail"                   => CheckStatusGroup("fStarFilesAvailStatus",      $_GET),
     "fGanymed"                          => CheckStatusGroup("fGanymedStatus",             $_GET),
     "fFillGanymed"                      => CheckStatusGroup("fFillGanymedStatus",         $_GET),
    );


$checkenumgroup = array
    (
     "fHasSignal"              => CheckEnumGroup("fHasSignalEnum",             $_GET),
     "fHasPedestal"            => CheckEnumGroup("fHasPedestalEnum",           $_GET),
     "fHasSignalInterlaced"    => CheckEnumGroup("fHasSignalInterlacedEnum",   $_GET),
     "fHasPedestalInterlaced"  => CheckEnumGroup("fHasPedestalInterlacedEnum", $_GET),
    );



$alias = array
    (
     "fRawFileKEY"                      => "Idx",
     "fMagicNumberName"                 => "Magic#",
     "fFormatVersion"                   => "F-Ver",
     "fLastUpdate"                      => "LastUpd",
     "fRunNumber"                       => "Run#",
     "fRunTypeName"                     => "RunType",
     "fMeanTriggerRate"                 => "Rate<br>[Hz]",
     "fDaqTriggerRate"                  => "Daq<br>TRate<br>[Hz]",
     "fDaqStoreRate"                    => "Daq<br>SRate<br>[Hz]",
     "fL2RatePresc"                     => "L2<br>pRate<br>[Hz]",
     "fL2RateUnpresc"                   => "L2<br>upRate<br>[Hz]",
     "fManuallyChangedName"             => "Manually<br>Changed",
     "fObservationModeName"             => "Obs.<br>Mode",
     "fLastUpdate"                      => "LastUpd",
     "fSequenceFirst"                   => "Sequ",
     "fProjectName"                     => "Project",
     "fSourceName"                      => "Source",
     "fNumEvents"                       => "#Evts",
     "fRunTime/60"                      => "Up<br>Time<br>[min]",
     "fRunStart"                        => "Start",
     "fRunStop"                         => "Stop",
//     "fRunStart"                        => "StartTime",
     "fSequenceLast"                    => "Last<br>Run",
     "fL1TriggerTableName"              => "L1Trig<br>Table",
     "fL2TriggerTableName"              => "L2Trig<br>Table",
     "fHvSettingsName"                  => "HV Settings",
     "fCalibrationScriptName"           => "Cal Script",
     "fTestFlagName"                    => "Testflag",
     "fLightConditionsName"             => "Lightcond",
     "fTriggerDelayTableName"           => "TrigDelay",
     "fDiscriminatorThresholdTableName" => "DT",
     "fExcludedFDAName"                 => "Exclusion",
     "fZenithDistance"                  => "Zd",
     "fAzimuth"                         => "Az",
     "fZenithDistanceMin"               => "Zd<br>Min",
     "fZenithDistanceMax"               => "Zd<br>Max",
     "fAzimuthMin"                      => "Az<br>Min",
     "fAzimuthMax"                      => "Az<br>Max",
     "fTest"                            => "Test",
     "fSourceKEY"                       => "KEY",
     "fDate"                            => "Date",
     "fCCFilled"                        => "CCFilled",
     "fExclusionsDone"                  => "Exclusions",
     "fSequenceEntriesBuilt"            => "Sequences",
     "fCCFileAvail"                     => "CCFile",
     "fCaCoFileAvail"                   => "CaCoFile",
     "fCaCoFileFound"                   => "CaCoRun",
     "fRawFileAvail"                    => "RawFile",
     "fTimingCorrection"                => "TimingCorr",
     "fDataCheckDone"                   => "Datacheck",
//     "fFillDotRaw"                      => "Filldotraw",
     "fSequenceFileWritten"             => "SequFile",
     "fAllFilesAvail"                   => "FilesAvail",
     "fCallisto"                        => "Callisto",
     "fStar"                            => "Star",
     "fFillCallisto"                    => "FillCal",
     "fFillStar"                        => "FillStar",
     "fDataSetInserted"                 => "DataSet",
     "fDataSetFileWritten"              => "DataSetFile",
     "fStarFilesAvail"                  => "FilesAvail",
     "fGanymed"                         => "Ganymed",
     "fFillGanymed"                     => "FillGanymed",
     "fUnsuitableOuter"                 => "Un<br>suit.<br>Out",
     "fUnreliableOuter"                 => "Un<br>rel.<br>Out",
     "fUnreliableInner"                 => "Un<br>rel.<br>In",
     "fUnsuitableInner"                 => "Un<br>suit.<br>In",
     "fUnsuitable50"                    => "Un<br>suit.<br>50",
     "fUnsuitable01"                    => "Un<br>suit.<br>01",
     "fUnsuitableMax"                   => "Un<br>suit.<br>Max",
     "fDeadMax"                         => "Dead<br>Max",
     "fRateTrigEvts"                    => "Rate Trig.<br>Evts [Hz]",
     "fRateSumEvts"                     => "Rate Sum<br>Evts [Hz]",
     "fRatePedEvts"                     => "Rate Ped<br>Evts [Hz]",
     "fRatePedTrigEvts"                 => "Rate Ped.Trig.<br>Evts [Hz]",
     "fRateCalEvts"                     => "Rate Cal.<br>Evts [Hz]",
     "fRateNullEvts"                    => "Rate Null<br>Evts [Hz]",
     "fRateUnknownEvts"                 => "Rate Unknown<br>Evts [Hz]",
     "fRatioCalEvents"                  => "Ratio Cal.<br>Events",
     "fPulsePosCalib"                   => "Pulse Pos.<br>Calib",
     "fIsolatedOuter"                   => "Isol.<br>Out",
     "fIsolatedInner"                   => "Isol.<br>In",
     "fMeanPedRmsOuter"                 => "Ped<br>Rms<br>Out",
     "fMeanPedRmsInner"                 => "Ped<br>Rms<br>In",
     "fArrTimeMeanInner"                => "Arr<br>Time<br>In",
     "fArrTimeMeanOuter"                => "Arr<br>Time<br>Out",
     "fArrTimeRmsInner"                 => "Rms<br>ArrT<br>In",
     "fArrTimeRmsOuter"                 => "Rms<br>ArrT<br>Out",
     "fMeanSignalInner"                 => "Sign<br>In",
     "fMeanSignalOuter"                 => "Sign<br>Out",
     "fMeanPulsePosInner"               => "Pulse<br>PosIn",
     "fPulsePosMean"                    => "Puls<br>Pos",
     "fConvFactorInner"                 => "Conv<br>In",
     "fConvFactorOuter"                 => "Conv<br>Out",
     //             "fConvFactorInner"                 => "Conv Inner<BR>[ph/FADC]",
     //             "fConvFactorOuter"                 => "Conv Outer<BR>[ph/FADC]",
     "fIsolatedMaxCluster"              => "Isol.<br>Max<br>Cl",
     "fMeanNumberIslands"               => "Mean<br>Num<br>Isl",
     "fPSF"                             => "PSF<br>[mm]",
     "fRatio"                           => "Ratio<br>[%]",
     "fMuonNumber"                      => "#<br>Muons",
     "fEffOnTime"                       => "EffOn<br>Time<br>[s]",
     "fEffOnTime/fRunTime"              => "RelOn<br>Time",
     "fEffOnTime/3600"                  => "EffOn<br>Time<br>[h]",
     "fMuonRate"                        => "Muon<br>Rate<br>[Hz]",
     "fInhomogeneity"                   => "Inhom",
     "fDataRate"                        => "Img.<br>Rate<br>[Hz]",
     "fSparkRate"                       => "Spark<br>Rate<br>[Hz]",
     "fMaxHumidity"                     => "Max<br>Hum<br>[%]",
     "fBrightnessMed"                   => "Sky<br>Brightn.<br>Med",
     "fBrightnessRMS"                   => "Sky<br>Brightn.<br>RMS",
     "fNumStarsMed"                     => "#<br>id.<br>stars",
     "fNumStarsRMS"                     => "RMS<br>id.<br>stars",
     "fNumStarsCorMed"                  => "#<br>cor.<br>stars",
     "fNumStarsCorRMS"                  => "RMS<br>cor.<br>stars",
     "fAvgWindSpeed"                    => "Avg. wind<br>speed [m/s]",
     "fAvgTemperature"                  => "Avg. temp.<br>[deg]",
     "fAvgHumidity"                     => "Avg. hum.<br>[%]",
     "fAvgTempSky"                      => "Avg. sky<br>temp [deg]",
     "fAvgCloudiness"                   => "Avg. cloud.<br>[%]",
     "fRmsCloudiness"                   => "RMS cloud.<br>[%]",
     "fEvents"                          => "DataEvents",
     "fPositionSignal"                  => "ArrTime",
     "fPositionFWHM"                    => "ArrTimeFWHM",
     "fHeightSignal"                    => "Signal",
     "fHeightFWHM"                      => "SignalFWHM",
     "fHasSignal"                       => "HasSignal",
     "fHasPedestal"                     => "HasPedestal",
     "fPositionAsym"                    => "ArrTimeAsym",
     "fHeightAsym"                      => "SignalAsym",
     "fEventsInterlaced"                => "CalEvents",
     "fPositionSignalInterlaced"        => "ArrTimeCal",
     "fPositionFWHMInterlaced"          => "ArrTimeFWHMCal",
     "fHeightSignalInterlaced"          => "SignalCal",
     "fHeightFWHMInterlaced"            => "SignalFWHMCal",
     "fHasSignalInterlaced"             => "HasSignalCal",
     "fHasPedestalInterlaced"           => "HasPedestalCal",
     "fPositionAsymInterlaced"          => "ArrTimeAsymCal",
     "fHeightAsymInterlaced"            => "SignalAsymCal",
     "fExcessEvents"                    => "Exc<br>Evts",
     "fBackgroundEvents"                => "Bg<br>Evts",
     "fSignalEvents"                    => "Sign<br>Evts",
     "fSignificance"                    => "Sign",
     "fScaleFactor"                     => "Scale",
     "fDataSetNumber"                   => "Data<br>Set#",
     "fComment"                         => "Comment",
     "fUserName"                        => "User",
     "fRunTime"                         => "Up<br>Time<br>[min]",
     "fDataSetName"                     => "Name",
     "fExcessEvents*60/fEffOnTime"      => "Exc<br>Rate",
     "fBackgroundEvents*60/fEffOnTime"  => "Bg<br>Rate",
     "fSignalEvents*60/fEffOnTime"      => "Sign<br>Rate",
     "Round(fSignificance/Sqrt(fEffOnTime/3600),2)" => "Signf<br>Rate",
     "SUM(fRunTime)/3600"               => "Time [h]",
     "SUM(fNumEvents)"                  => "Evts",
     "Min(fZenithDistanceMin)"          => "ZDMin",
     "Max(fZenithDistanceMax)"          => "ZDMax",
     "Min(fZenithDistance)"             => "ZdMin",
     "Max(fZenithDistance)"             => "ZdMax",
//     "fArrTimeLimit"                    => "ArrTRms",
//     "fArrTimeLimit"                    => "ArrTime",
     "fPulsePosLimit"                   => "PulsePos",
     "fRunTimeLimit"                    => "UpTime",
     "fPedRmsInLimit"                   => "PedRms",
     "fMuonRateLimit"                   => "MuonRate",
     "fMuonNumLimit"                    => "# Muons",
     "fMuonCalLimit"                    => "MuonCal",
     "fPSFLimit"                        => "PSF",
     "fInhomLimit"                      => "Inhom.",
     "fNumIslLimit"                     => "# Islands",
     "fImgRateLimit"                    => "ImgRate",
     "fSkyBrightLimit"                  => "SkyBrightness",
     "fNumStarsLimit"                   => "# id. Stars",
     "fNumStarsCorLimit"                => "# cor. Stars",
     "fUnsInLimit"                      => "Unsuit.In",
     "fIsoInLimit"                      => "Isol.In",
     "fIMCLimit"                        => "IMC",
     "fMaxHumLimit"                     => "Humidity",
     "fZdMinLimit"                      => "ZdMin",
     "fZdMaxLimit"                      => "ZdMax",
     "fRelTimeMaxLimit"                 => "Rel.Ontime",
     "fRelTimeMinLimit"                 => "Rel.Ontime",
     "fEMin"                            => "Emin",
     "fEMax"                            => "Emax",
     "fParticleTypeName"                => "Particle",
     "fStartTime"                       => "Process",
     "fFailedTime"                      => "Failed",
     "fReturnCode"                      => "Ret<br>Code",
     "fProgramId"                       => "Prgr<br>Id",
     "fTimestamp"                       => "Time",
     "fExposure"                        => "Exposure",
     "fFitsFileName"                    => "FitsFile",
     "fObjectName"                      => "Object",
     "fSkyLevel"                        => "SkyLevel",
     "fFWHM"                            => "FWHM",
     "fApertureRadius"                  => "Ap.Rad.",
     "fInstrumentalMag"                 => "Instr.Mag.",
     "fInstrumentalMagErr"              => "Instr.Mag.Err.",
     "fStatusName"                      => "StatusCode",
     "fTelescopeName"                   => "Telescope",
     "fBandName"                        => "Band",
//     "COUNT(*)"                         => "# Runs",
//     "COUNT(*)"                         => "Sequence",
    );


$rightalign = array
    (
     $alias["fRawFileKEY"]               => "1",
     $alias["fFormatVersion"]            => "1",
     $alias["fRunNumber"]                => "1",
     $alias["fZenithDistance"]           => "1",
     $alias["fAzimuth"]                  => "1",
     $alias["fMeanTriggerRate"]          => "1",
     $alias["fDaqTriggerRate"]           => "1",
     $alias["fDaqStoreRate"]             => "1",
     $alias["fL2RatePresc"]              => "1",
     $alias["fL2RateUnpresc"]            => "1",
     $alias["fSequenceFirst"]            => "1",
     $alias["fNumEvents"]                => "1",
     $alias["fRunTime/60"]               => "1",
     $alias["fSequenceLast"]             => "1",
     $alias["fZenithDistanceMin"]        => "1",
     $alias["fZenithDistanceMax"]        => "1",
     $alias["fAzimuthMin"]               => "1",
     $alias["fAzimuthMax"]               => "1",
     $alias["fUnsuitableOuter"]          => "1",
     $alias["fUnreliableOuter"]          => "1",
     $alias["fUnsuitableInner"]          => "1",
     $alias["fUnreliableInner"]          => "1",
     $alias["fUnsuitable50"]             => "1",
     $alias["fUnsuitable01"]             => "1",
     $alias["fUnsuitableMax"]            => "1",
     $alias["fDeadMax"]                  => "1",
     $alias["fRateTrigEvts"]             => "1",
     $alias["fRateSumEvts"]              => "1",
     $alias["fRatePedEvts"]              => "1",
     $alias["fRatePedTrigEvts"]          => "1",
     $alias["fRateCalEvts"]              => "1",
     $alias["fRateNullEvts"]             => "1",
     $alias["fRateUnknownEvts"]          => "1",
     $alias["fRatioCalEvents"]           => "1",
     $alias["fPulsePosCalib"]            => "1",
     $alias["fIsolatedOuter"]            => "1",
     $alias["fIsolatedInner"]            => "1",
     $alias["fMeanPedRmsOuter"]          => "1",
     $alias["fMeanPedRmsInner"]          => "1",
     $alias["fArrTimeMeanInner"]         => "1",
     $alias["fArrTimeMeanOuter"]         => "1",
     $alias["fArrTimeRmsInner"]          => "1",
     $alias["fArrTimeRmsOuter"]          => "1",
     $alias["fMeanSignalInner"]          => "1",
     $alias["fMeanSignalOuter"]          => "1",
     $alias["fPulsePosMean"]             => "1",
     $alias["fConvFactorInner"]          => "1",
     $alias["fConvFactorOuter"]          => "1",
     $alias["fIsolatedMaxCluster"]       => "1",
     $alias["fMeanNumberIslands"]        => "1",
     $alias["fPSF"]                      => "1",
     $alias["fRatio"]                    => "1",
     $alias["fMuonNumber"]               => "1",
     $alias["fEffOnTime"]                => "1",
     $alias["fEffOnTime/fRunTime"]       => "1",
     $alias["fEffOnTime/3600"]           => "1",
     $alias["fMuonRate"]                 => "1",
     $alias["fInhomogeneity"]            => "1",
     $alias["fDataRate"]                 => "1",
     $alias["fSparkRate"]                => "1",
     $alias["fMaxHumidity"]              => "1",
     $alias["fBrightnessMed"]            => "1",
     $alias["fBrightnessRMS"]            => "1",
     $alias["fNumStarsMed"]              => "1",
     $alias["fNumStarsRMS"]              => "1",
     $alias["fNumStarsCorMed"]           => "1",
     $alias["fNumStarsCorRMS"]           => "1",
     $alias["fAvgWindSpeed"]             => "1",
     $alias["fAvgTemperature"]           => "1",
     $alias["fAvgHumidity"]              => "1",
     $alias["fAvgTempSky"]               => "1",
     $alias["fAvgCloudiness"]            => "1",
     $alias["fRmsCloudiness"]            => "1",
     $alias["fDate"]                     => "1",
     $alias["fCaCoFileFound"]            => "1",
     $alias["fTest"]                     => "1",
     $alias["fSourceKEY"]                => "1",
     $alias["fEvents"]                   => "1",
     $alias["fPositionSignal"]           => "1",
     $alias["fPositionFWHM"]             => "1",
     $alias["fHeightSignal"]             => "1",
     $alias["fHeightFWHM"]               => "1",
     $alias["fHasSignal"]                => "1",
     $alias["fHasPedestal"]              => "1",
     $alias["fPositionAsym"]             => "1",
     $alias["fHeightAsym"]               => "1",
     $alias["fEventsInterlaced"]         => "1",
     $alias["fPositionSignalInterlaced"] => "1",
     $alias["fPositionFWHMInterlaced"]   => "1",
     $alias["fHeightSignalInterlaced"]   => "1",
     $alias["fHeightFWHMInterlaced"]     => "1",
     $alias["fHasSignalInterlaced"]      => "1",
     $alias["fHasPedestalInterlaced"]    => "1",
     $alias["fPositionAsymInterlaced"]   => "1",
     $alias["fHeightAsymInterlaced"]     => "1",
     $alias["fReturnCode"]               => "1",
     $alias["fProgramId"]                => "1",
     "Time"                              => "1",
//     "Time [h]"                 => "1",
     "ZDMin"                             => "1",
     "ZDMax"                             => "1",
//     "Evts#"                    => "1",
//     "Runs#"                    => "1"
     "Runs"                              => "1",
     "Evts"                              => "1",
);

function GetCheck($fromtable, $val)
{
    $checks = array
        (
         "fRunTypeName"                      => $fromtable . ".fRunTypeKEY",
         "fProjectName"                      => $fromtable . ".fProjectKEY",
         "fSourceName"                       => $fromtable . ".fSourceKEY",
         "fMagicNumberName"                  => $fromtable . ".fMagicNumberKEY",
         "fL1TriggerTableName"               => $fromtable . ".fL1TriggerTableKEY",
         "fL2TriggerTableName"               => $fromtable . ".fL2TriggerTableKEY",
         "fHvSettingsName"                   => $fromtable . ".fHvSettingsKEY",
         "fCalibrationScriptName"            => $fromtable . ".fCalibrationScriptKEY",
         "fExcludedFDAName"                  => $fromtable . ".fExcludedFDAKEY",
         "fManuallyChangedName"              => $fromtable . ".fManuallyChangedKEY",
         "fObservationModeName"              => $fromtable . ".fObservationModeKEY",
         "fDiscriminatorThresholdTableName"  => $fromtable . ".fDiscriminatorThresholdTableKEY",
         "fTriggerDelayTableName"            => $fromtable . ".fTriggerDelayTableKEY",
         "fTestFlagName"                     => $fromtable . ".fTestFlagKEY",
         "fLightConditionsName"              => $fromtable . ".fLightConditionsKEY",
         "fParticleTypeName"                 => $fromtable . ".fParticleTypeKEY",
         "fFitsFileName"                     => $fromtable . ".fFitsFileKEY",
         "fObjectName"                       => $fromtable . ".fObjectKEY",
         "fStatusName"                       => $fromtable . ".fStatusKEY",
         "fBandName"                         => $fromtable . ".fBandKEY",
         "fUserName"                         => $fromtable . ".fUserKEY",
         "fTelescopeName"                    => $fromtable . ".fTelescopeKEY",
        );

    $check="";
    if (!empty($checks[$val]))
        $check=$checks[$val];
    return $check;
}


function GetTable($fromtable, $val)
{
    $tables = array
        (
         "fSequenceFirst"                    => $fromtable . ".fSequenceFirst",
         "fSequenceLast"                     => $fromtable . ".fSequenceLast",
         "fNumEvents"                        => $fromtable . ".fNumEvents",
         "fRunStart"                         => $fromtable . ".fRunStart",
         "fLastUpdate"                       => $fromtable . ".fLastUpdate",
         "fRunTime"                          => $fromtable . ".fRunTime",
         "fRunTime/60"                       => $fromtable . ".fRunTime/60",
         "fAzimuthMin"                       => $fromtable . ".fAzimuthMin",
         "fAzimuthMax"                       => $fromtable . ".fAzimuthMax",
         "fZenithDistanceMin"                => $fromtable . ".fZenithDistanceMin",
         "fZenithDistanceMax"                => $fromtable . ".fZenithDistanceMax",
         "fRunNumber"                        => "RunData.fRunNumber",
         "fRunStop"                          => "RunData.fRunStop",
         "fAzimuth"                          => "RunData.fAzimuth",
         "fZenithDistance"                   => "RunData.fZenithDistance",
         "fFormatVersion"                    => "RunData.fFormatVersion",
         "fRunTypeName"                      => "RunType.fRunTypeName",
         "fDaqStoreRate"                     => "RunData.fDaqStoreRate",
         "fDaqTriggerRate"                   => "RunData.fDaqTriggerRate",
         "fMeanTriggerRate"                  => "RunData.fMeanTriggerRate",
         "fL2RatePresc"                      => "RunData.fL2RatePresc",
         "fL2RateUnpresc"                    => "RunData.fL2RateUnpresc",
         "fMagicNumberName"                  => "MagicNumber.fMagicNumberName",
         "fExcludedFDAName"                  => "ExcludedFDA.fExcludedFDAName",
         "fProjectName"                      => "Project.fProjectName",
         "fSourceName"                       => "Source.fSourceName",
         "fL1TriggerTableName"               => "L1TriggerTable.fL1TriggerTableName",
         "fL2TriggerTableName"               => "L2TriggerTable.fL2TriggerTableName",
         "fHvSettingsName"                   => "HvSettings.fHvSettingsName",
         "fManuallyChangedName"              => "ManuallyChanged.fManuallyChangedName",
         "fObservationModeName"              => "ObservationMode.fObservationModeName",
         "fTriggerDelayTableName"            => "TriggerDelayTable.fTriggerDelayTableName",
         "fDiscriminatorThresholdTableName"  => "DiscriminatorThresholdTable.fDiscriminatorThesholdTableName",
         "fCalibrationScriptName"            => "CalibrationScript.fCalibrationScriptName",
         "fTestFlagName"                     => "TestFlag.fTestFlagName",
         "fLightConditionsName"              => "LightConditions.fLightConditionsName",
         "fRawFileAvail"                     => "RunProcessStatus.fRawFileAvail",
         "fCCFileAvail"                      => "RunProcessStatus.fCCFileAvail",
         "fCaCoFileAvail"                    => "RunProcessStatus.fCaCoFileAvail",
         "fCaCoFileFound"                    => "RunProcessStatus.fCaCoFileFound",
         "fTimingCorrection"                 => "RunProcessStatus.fTimingCorrection",
//         "fFillDotRaw"                       => "RunProcessStatus.fFillDotRaw",
         "fSequenceFileWritten"              => "SequenceProcessStatus.fSequenceFileWritten",
         "fAllFilesAvail"                    => "SequenceProcessStatus.fAllFilesAvail",
         "fCallisto"                         => "SequenceProcessStatus.fCallisto",
         "fFillCallisto"                     => "SequenceProcessStatus.fFillCallisto",
         "fStar"                             => "SequenceProcessStatus.fStar",
         "fFillStar"                         => "SequenceProcessStatus.fFillStar",
         "fUnsuitableInner"                  => "Calibration.fUnsuitableInner",
         "fUnsuitableOuter"                  => "Calibration.fUnsuitableOuter",
         "fUnsuitable50"                     => "Calibration.fUnsuitable50",
         "fUnsuitable01"                     => "Calibration.fUnsuitable01",
         "fUnsuitableMax"                    => "Calibration.fUnsuitableMax",
         "fDeadMax"                          => "Calibration.fDeadMax",
         "fRateTrigEvts"                     => "Calibration.fRateTrigEvts",
         "fRateSumEvts"                      => "Calibration.fRateSumEvts",
         "fRatePedEvts"                      => "Calibration.fRatePedEvts",
         "fRatePedTrigEvts"                  => "Calibration.fRatePedTrigEvts",
         "fRateCalEvts"                      => "Calibration.fRateCalEvts",
         "fRateNullEvts"                     => "Calibration.fRateNullEvts",
         "fRateUnknownEvts"                  => "Calibration.fRateUnknownEvts",
         "fRatioCalEvents"                   => "Calibration.fRatioCalEvents",
         "fPulsePosCalib"                    => "Calibration.fPulsePosCalib",
         "fUnreliableInner"                  => "Calibration.fUnreliableInner",
         "fUnreliableOuter"                  => "Calibration.fUnreliableOuter",
         "fIsolatedInner"                    => "Calibration.fIsolatedInner",
         "fIsolatedOuter"                    => "Calibration.fIsolatedOuter",
         "fIsolatedMaxCluster"               => "Calibration.fIsolatedMaxCluster",
         "fLastUpdate"                       => "Calibration.fLastUpdate",
         "fMeanPedRmsInner"                  => "Calibration.fMeanPedRmsInner",
         "fMeanPedRmsOuter"                  => "Calibration.fMeanPedRmsOuter",
         "fArrTimeMeanInner"                 => "Calibration.fArrTimeMeanInner",
         "fArrTimeMeanOuter"                 => "Calibration.fArrTimeMeanOuter",
         "fArrTimeRmsInner"                  => "Calibration.fArrTimeRmsInner",
         "fArrTimeRmsOuter"                  => "Calibration.fArrTimeRmsOuter",
         "fMeanSignalInner"                  => "Calibration.fMeanSignalInner",
         "fMeanSignalOuter"                  => "Calibration.fMeanSignalOuter",
         "fPulsePosMean"                     => "Calibration.fPulsePosMean",
         "fConvFactorInner"                  => "Calibration.fConvFactorInner",
         "fConvFactorOuter"                  => "Calibration.fConvFactorOuter",
         "fMeanNumberIslands"                => "Star.fMeanNumberIslands",
         "fPSF"                              => "Star.fPSF",
         "fRatio"                            => "Star.fRatio",
         "fMuonNumber"                       => "Star.fMuonNumber",
         "fEffOnTime"                        => "fEffOnTime",
         "fEffOnTime/fRunTime"               => "Sequences.fRunTime/Star.fEffOnTime",
         "fEffOnTime/3600"                   => "fEffOnTime/3600",
//         "fEffOnTime"                        => $fromtable . ".fEffOnTime",
         "fMuonRate"                         => "Star.fMuonRate",
         "fInhomogeneity"                    => "Star.fInhomogeneity",
         "fDataRate"                         => "Star.fDataRate",
         "fSparkRate"                        => "Star.fSparkRate",
         "fMaxHumidity"                      => "Star.fMaxHumidity",
         "fBrightnessMed"                    => "Star.fBrightnessMed",
         "fBrightnessRMS"                    => "Star.fBrightnessRMS",
         "fNumStarsMed"                      => "Star.fNumStarsMed",
         "fNumStarsRMS"                      => "Star.fNumStarsRMS",
         "fNumStarsCorMed"                   => "Star.fNumStarsCorMed",
         "fNumStarsCorRMS"                   => "Star.fNumStarsCorRMS",
         "fAvgWindSpeed"                     => "Star.fAvgWindSpeed",
         "fAvgTemperature"                   => "Star.fAvgTemperature",
         "fAvgHumidity"                      => "Star.fAvgHumidity",
         "fAvgTempSky"                       => "Star.fAvgTempSky",
         "fAvgCloudiness"                    => "Star.fAvgCloudiness",
         "fRmsCloudiness"                    => "Star.fRmsCloudiness",
         "fDataSetNumber"                    => $fromtable . ".fDataSetNumber",
         "fDataSetInserted"                  => "DataSetProcessStatus.fDataSetInserted",
         "fDataSetFileWritten"               => "DataSetProcessStatus.fDataSetFileWritten",
         "fStarFilesAvail"                   => "DataSetProcessStatus.fStarFilesAvail",
         "fGanymed"                          => "DataSetProcessStatus.fGanymed",
         "fFillGanymed"                      => "DataSetProcessStatus.fFillGanymed",
         "fComment"                          => "DataSets.fComment",
         "fDataSetName"                      => "DataSets.fDataSetName",
         "fEvents"                           => "DataCheck.fEvents",
         "fPositionSignal"                   => "DataCheck.fPositionSignal",
         "fPositionFWHM"                     => "DataCheck.fPositionFWHM",
         "fHeightSignal"                     => "DataCheck.fHeightSignal",
         "fHeightFWHM"                       => "DataCheck.fHeightFWHM",
         "fHasSignal"                        => "DataCheck.fHasSignal",
         "fHasPedestal"                      => "DataCheck.fHasPedestal",
         "fPositionAsym"                     => "DataCheck.fPositionAsym",
         "fHeightAsym"                       => "DataCheck.fHeightAsym",
         "fEventsInterlaced"                 => "DataCheck.fEventsInterlaced",
         "fPositionSignalInterlaced"         => "DataCheck.fPositionSignalInterlaced",
         "fPositionFWHMInterlaced"           => "DataCheck.fPositionFWHMInterlaced",
         "fHeightSignalInterlaced"           => "DataCheck.fHeightSignalInterlaced",
         "fHeightFWHMInterlaced"             => "DataCheck.fHeightFWHMInterlaced",
         "fHasSignalInterlaced"              => "DataCheck.fHasSignalInterlaced",
         "fHasPedestalInterlaced"            => "DataCheck.fHasPedestalInterlaced",
         "fPositionAsymInterlaced"           => "DataCheck.fPositionAsymInterlaced",
         "fHeightAsymInterlaced"             => "DataCheck.fHeightAsymInterlaced",
         "fExcessEvents"                     => "Ganymed.fExcessEvents",
         "fBackgroundEvents"                 => "Ganymed.fBackgroundEvents",
         "fSignalEvents"                     => "Ganymed.fSignalEvents",
         "fSignificance"                     => "Ganymed.fSignificance",
         "fScaleFactor"                      => "Ganymed.fScaleFactor",
         "fExcessEvents*60/fEffOnTime"       => "fExcessEvents*60/fEffOnTime",
         "fBackgroundEvents*60/fEffOnTime"   => "fBackgroundEvents*60/fEffOnTime",
         "fSignalEvents*60/fEffOnTime"       => "fSignalEvents*60/fEffOnTime",
         "Round(fSignificance/Sqrt(fEffOnTime/3600),2)" => "Round(fSignificance/Sqrt(fEffOnTime/3600),2)",
         "SUM(fRunTime)/3600"                => "'Time [h]'",
         "SUM(fNumEvents)"                   => "'Evts'",
         "Min(fZenithDistanceMin)"           => "'ZDMin'",
         "Max(fZenithDistanceMax)"           => "'ZDMax'",
         "Min(fZenithDistance)"              => "'ZdMin'",
         "Max(fZenithDistance)"              => "'ZdMax'",
//         "COUNT(*)"                          => "'Sequence'",
         "fStartTime"                        => "fStartTime",
         "fFailedTime"                       => "fFailedTime",
         "fReturnCode"                       => "fReturnCode",
         "fProgramId"                        => "fProgramId",
         "fParticleTypeName"                 => "ParticleType.fParticleTypeName",
         "fFitsFileName"                     => "FitsFile.fFitsFileName",
         "fObjectName"                       => "Object.fObjectName",
         "fStatusName"                       => "Status.fStatusName",
         "fBandName"                         => "Band.fBandName",
         "fTelescopeName"                    => "Telescope.fTelescopeName",
         "fUserName"                         => "User.fUserName",
        );

    $table="";
    if (!empty($tables[$val]))
        $table=$tables[$val];
    if ($val=="NumRuns")
        $table="'# Runs'";
    if ($val=="NumSequ")
        $table="'# Sequ'";
    if ($val=="NumDS")
        $table="'# Datasets'";
    if ($val=="NumDays")
        $table="'# days'";
    if (empty($table))
        $table=$val;
    return $table;
}


function GetJoin($fromtable, $val)
{
    $joins = array
        (
         "fRunTypeName"                      => " LEFT JOIN RunType                      ON " . $fromtable . ".fRunTypeKEY=RunType.fRunTypeKEY ",
         "fProjectName"                      => " LEFT JOIN Project                      ON " . $fromtable . ".fProjectKEY=Project.fProjectKEY ",
         "fSourceName"                       => " LEFT JOIN Source                       ON " . $fromtable . ".fSourceKEY=Source.fSourceKEY ",
         "fMagicNumberName"                  => " LEFT JOIN MagicNumber                  ON " . $fromtable . ".fMagicNumberKEY=MagicNumber.fMagicNumberKEY ",
         "fL1TriggerTableName"               => " LEFT JOIN L1TriggerTable               ON " . $fromtable . ".fL1TriggerTableKEY=L1TriggerTable.fL1TriggerTableKEY",
         "fL2TriggerTableName"               => " LEFT JOIN L2TriggerTable               ON " . $fromtable . ".fL2TriggerTableKEY=L2TriggerTable.fL2TriggerTableKEY",
         "fHvSettingsName"                   => " LEFT JOIN HvSettings                   ON " . $fromtable . ".fHvSettingsKEY=HvSettings.fHvSettingsKEY",
         "fCalibrationScriptName"            => " LEFT JOIN CalibrationScript            ON " . $fromtable . ".fCalibrationScriptKEY=CalibrationScript.fCalibrationScriptKEY",
         "fExcludedFDAName"                  => " LEFT JOIN ExcludedFDA                  ON " . $fromtable . ".fExcludedFDAKEY=ExcludedFDA.fExcludedFDAKEY",
         "fManuallyChangedName"              => " LEFT JOIN ManuallyChanged              ON " . $fromtable . ".fManuallyChangedKEY=ManuallyChanged.fManuallyChangedKEY ",
         "fObservationModeName"              => " LEFT JOIN ObservationMode              ON " . $fromtable . ".fObservationModeKEY=ObservationMode.fObservationModeKEY ",
         "fDiscriminatorThresholdTableName"  => " LEFT JOIN DiscriminatorThresholdTable  ON " . $fromtable . ".fDiscriminatorThresholdTableKEY=DiscriminatorThresholdTable.fDiscriminatorThresholdTableKEY ",
         "fTriggerDelayTableName"            => " LEFT JOIN TriggerDelayTable            ON " . $fromtable . ".fTriggerDelayTableKEY=TriggerDelayTable.fTriggerDelayTableKEY ",
         "fTestFlagName"                     => " LEFT JOIN TestFlag                     ON " . $fromtable . ".fTestFlagKEY=TestFlag.fTestFlagKEY",
         "fLightConditionsName"              => " LEFT JOIN LightConditions              ON " . $fromtable . ".fLightConditionsKEY=LightConditions.fLightConditionsKEY",
         "fParticleTypeName"                 => " LEFT JOIN ParticleType                 ON " . $fromtable . ".fParticleTypeKEY=ParticleType.fParticleTypeKEY ",
         "fFitsFileName"                     => " LEFT JOIN FitsFile                     ON " . $fromtable . ".fFitsFileKEY=FitsFile.fFitsFileKEY",
         "fObjectName"                       => " LEFT JOIN Object                       ON " . $fromtable . ".fObjectKEY=Object.fObjectKEY ",
         "fStatusName"                       => " LEFT JOIN Status                       ON " . $fromtable . ".fStatusKEY=Status.fStatusKEY ",
         "fBandName"                         => " LEFT JOIN Band                         ON " . $fromtable . ".fBandKEY=Band.fBandKEY ",
         "fUserName"                         => " LEFT JOIN User                         ON " . $fromtable . ".fUserKEY=User.fUserKEY ",
         "fTelescopeName"                    => " LEFT JOIN Telescope                    ON " . $fromtable . ".fTelescopeKEY=Telescope.fTelescopeKEY ",
        );


    $join="";
    if (!empty($joins[$val]))
        $join=$joins[$val];
    return $join;
}


?>
