/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  5/2002 <mailto:(tbretz@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2002
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
//  STAR - STandard Analysis and Reconstruction
//
//  This macro is the standard converter to convert raw data into image
//  parameters
//
/////////////////////////////////////////////////////////////////////////////

void star()
{
    //
    // This is a demonstration program which calculates the image 
    // parameters from a Magic raw data root file.

    //
    // Create a empty Parameter List and an empty Task List
    // The tasklist is identified in the eventloop by its name
    //
    MParList  plist;

    MTaskList tlist;
    plist.AddToList(&tlist);

    MSrcPosCam src;
    plist.AddToList(&src);

    //
    // Uncomment this two line if you want to use MHillasExt instead
    // of MHillas
    //
    MHillasExt hext;
    plist.AddToList(&hext);

    //
    // The geometry container must be created by yourself to make sure
    // that you don't choose a wrong geometry by mistake
    //
    MGeomCamMagic geomcam;
    plist.AddToList(&geomcam);

    //
    // Now setup the tasks and tasklist:
    // ---------------------------------
    //
    MReadMarsFile read("Events");
    read.DisableAutoScheme();

    // ------------- user change -----------------
    read.AddFile("Pro*.root");
    //read.AddFile("Gam*.root");

    MMcPedestalCopy   pcopy;
    MMcPedestalNSBAdd pnsb;
    MCerPhotCalc      ncalc;

    MBlindPixelCalc   blind;
    blind.SetUseInterpolation();

    MImgCleanStd      clean;
    MHillasCalc       hcalc;
    MHillasSrcCalc    scalc; // !!Preliminary!! Will be removed later!

    // ------------- user change -----------------
    MWriteRootFile write("data/star_protons.root");
    write.AddContainer("MHillas",       "Events");
    write.AddContainer("HillasSource",  "Events");
    write.AddContainer("MMcEvt",        "Events");
    write.AddContainer("MHillasSrc",    "Events");
    write.AddContainer("MRawRunHeader", "RunHeaders");
    write.AddContainer("MMcRunHeader",  "RunHeaders");

    tlist.AddToList(&read);
    tlist.AddToList(&pcopy);
    tlist.AddToList(&pnsb);
    tlist.AddToList(&ncalc);
    tlist.AddToList(&blind);
    tlist.AddToList(&clean);
    tlist.AddToList(&hcalc);
    tlist.AddToList(&scalc);
    tlist.AddToList(&write);

    //
    // Create and set up the eventloop
    //
    MProgressBar bar;

    MEvtLoop evtloop;
    evtloop.SetProgressBar(&bar);
    evtloop.SetParList(&plist);

    //
    // Execute your analysis
    //
    if (!evtloop.Eventloop())
        return;

    tlist.PrintStatistics();
}
