/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  12/2000 (tbretz@uni-sw.gwdg.de)
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */


void CT1collarea(TString filename="MC_ON2.root", TString outname="")
{ 
    //
    // first we have to create our empty lists
    //
    MParList  parlist;
    MTaskList tasklist;

    parlist.AddToList(&tasklist);

    //
    // Setup out tasks:
    //  - First we have to read the events
    //  - Then we can fill the efficiency histograms
    //
    MReadMarsFile reader("Events", filename);
    reader.EnableBranch("fHadronness");

    MMcCT1CollectionAreaCalc effi;
    MHMcCT1CollectionArea* collarea = new MHMcCT1CollectionArea("MHMcCT1CollectionArea","",30,2.,5.);
    parlist.AddToList(collarea);

    tasklist.AddToList(&reader);   

    MF filterhadrons("MHadronness.fHadronness<0.25");
    tasklist.AddToList(&filterhadrons);
    effi.SetFilter(&filterhadrons);

    tasklist.AddToList(&effi);

    //
    // set up the loop for the processing
    //
    MEvtLoop magic;
    magic.SetParList(&parlist);

    //
    // Start to loop over all events
    //
    MProgressBar bar;
    magic.SetProgressBar(&bar);
    if (!magic.Eventloop())
        return;

    tasklist.PrintStatistics();

    //
    // Now the histogram we wanted to get out of the data is
    // filled and can be displayed
    //
    parlist.FindObject("MHMcCT1CollectionArea")->DrawClone();

    //
    // Write histogram to a file in case an output
    // filename has been supplied
    //
    if (outname.IsNull())
        return;

    TFile f("area.root","recreate");
    collarea->GetHist()->Write();
    collarea->GetHAll()->Write();
    collarea->GetHSel()->Write();
    f.Close();
}

