//   triglvl2.C
//  Macro to use the class MMcTriggerLvl2, which calculates the 
//   2nd level trigger (L2T) selection parameters.
//  Filters to select events using these parameter and 
//  histograms with selection variables distributions are also created.
//
//   Inputs:
//      - filename      name of data file
//      - CompactNN     number of NN to define a compact pixel
//      - fValue        comparision value for the filter
//
//  23/04/2003 Added example of MFEnergySlope filter
//
//  
void triglvl2(char *filename = "Gamma.root")
  //    USER:   Data File Name    ---^
{ 
    //
    // first we have to create our empty lists
    //
    MParList  parlist;
    MTaskList tasklist;

    parlist.AddToList(&tasklist);

    MGeomCamMagic geocam;
    parlist.AddToList(&geocam);

    //    MHillas hillas;
    // parlist.AddToList(&hillas);

    // An instance of the class MMcTriggerLvl2 is created and added to the 
    //  parameter list
    MMcTriggerLvl2 cell;     
    parlist.AddToList(&cell);

    // Set the number of Next Neighbourhoods that define a compact pixel
    //
    cell.SetCompactNN(3);
    //  USER:       --^

    //
    //  A filter to select events using the L2T parameters is created
    //
    MF lvl2filter("MMcTriggerLvl2.fLutPseudoSize > 8");

    //
    // A second filter is created using the class MFTriggerLvl2
    //
    MFTriggerLvl2 fTrig("MMcTriggerLvl2", '>', 8);
    //      USER:       fValue to be compared --^

    //
    // A selection on the number and energy of the events 
    //
    MF energyfilter("MMcEvt.fEnergy > 100");
    MFEventSelector selector;
    //selector.SetNumSelectEvts(4000);


    // Filter to select events according to a give slope
    MFEnergySlope eslope;

    eslope.SetMcMinEnergy(50.);
    eslope.SetMcMaxEnergy(400.);
    eslope.SetNewSlope(-3.91);

    // A filter list is created; the filters created can be added to the list
    //
    MFilterList flist;
    //   flist.AddToList(&energyfilter);
    //   flist.AddToList(&lvl2filter);
    //   flist.AddToList(&selector);
    //   flist.AddToList(&eslope);
       flist.AddToList(&fTrig);


    // 
    // Setup our tasks:
    //  - First we have to read the events
    //  - Then we can fill the efficiency histograms
    //
    MReadMarsFile reader("Events", filename);
    reader.DisableAutoScheme();
     //  reader.EnableBranch("fEnergy");
     //  reader.EnableBranch("fImpact"); reader.EnableBranch("fTimeFirst[4]");
     //  reader.EnableBranch("fPixelsFirst[73][4]");
   
    tasklist.AddToList(&reader);

    //
    // The filter list is added to the task list
    //
    tasklist.AddToList(&flist);

    //
    //  Task to calculate and plot the effective area
    //
    MMcCollectionAreaCalc effi;
    tasklist.AddToList(&effi);

    //
    // The filter list selects events for the effective area calculation
    //
    effi.SetFilter(&flist);
 
    //
    // The task to calculate the L2T parameter is added to the task list
    //
    MMcTriggerLvl2Calc fill("MMcTriggerLvl2","MMcTriggerLvl2");  
    tasklist.AddToList(&fill);

    //
    // Filling of histos for MHMcTriggerLvl2
    //
    MFillH hfill1("MHMcTriggerLvl2","MMcTriggerLvl2");
    tasklist.AddToList(&hfill1);

    //
    // set up the loop for the processing
    //
    MEvtLoop magic;
    magic.SetParList(&parlist);

    //
    // Start to loop over all events
    //
    MProgressBar bar;
    magic.SetProgressBar(&bar);

    if (!magic.Eventloop())
      return;

    tasklist.PrintStatistics();
 
    //
    // Now the histogram we wanted to get out of the data is
    // filled and can be displayd
    //
    parlist.FindObject("MHMcCollectionArea")->DrawClone();

    parlist.FindObject("MHMcTriggerLvl2")->DrawClone("lps");
    //     parlist.FindObject("MHMcTriggerLvl2")->DrawClone();

    // Returns histogram of the class MHMcTriggerLvl2  
    //   parlist.FindObject("MHMcTriggerLvl2")->GetHistByName("hfPseudoSize"));
    
}



