/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  12/2000 (tbretz@uni-sw.gwdg.de)
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */

Bool_t isloaded()
{
    TString str = gSystem->GetLibraries("libmars.so");

    return !str.IsNull();
}

void unload()
{
    if (!isloaded())
        return;

    cout << "Unloading 'libmars.so'... " << flush;
    if (gSystem->Unload("libmars.so"))
        cout << "error." << endl;
    else
        cout << "done." << endl << endl;
}

bool load(TString &dir)
{
    if (isloaded())
        return;

    cout << "\033[33m\033[1m" << "Loading '" << dir << "libmars.so'... " << "\033[0m" << flush;

    if (dir.IsNull())
        dir = "./";

    if (gSystem->Load(dir+"libmars.so")!=0)
    {
        cout << "\033[33m\033[1m" << "error." << endl;
        cout << "\033[0m" << endl;
        return false;
    }
    else
    {
        MParContainer::Class()->IgnoreTObjectStreamer();
        MArray::Class()->IgnoreTObjectStreamer();
        cout << "\033[33m\033[1m" << "done." << endl;
        cout << "\033[0m" << endl;
        return true;
    }
}
/*
void make()
{
    unload();

    if (gSystem->Exec("make"))
    {
        cout << "Error calling make..." << endl;
        return;
    }

    load();
}
*/
void rootlogon()
{
    cout << endl;

    TString dir = gSystem->Getenv("MARSSYS");
    if (!dir.IsNull())
    {
        cout << "\033[34m\033[1m" << "Searching Mars in " << dir << " (MARSSYS)" << "\033[0m" << endl << endl;

        if (!dir.EndsWith("/"))
            dir += "/";
    }

    if (!load(dir))
        return;

    gInterpreter->AddIncludePath(dir+"macros");
    gInterpreter->AddIncludePath(dir+"manalysis");
    gInterpreter->AddIncludePath(dir+"mbase");
    gInterpreter->AddIncludePath(dir+"mcamera");
    gInterpreter->AddIncludePath(dir+"mcalib");
    gInterpreter->AddIncludePath(dir+"mdata");
    gInterpreter->AddIncludePath(dir+"mfileio");
    gInterpreter->AddIncludePath(dir+"mfilter");
    gInterpreter->AddIncludePath(dir+"mgeom");
    gInterpreter->AddIncludePath(dir+"mgui");
    gInterpreter->AddIncludePath(dir+"mhbase");
    gInterpreter->AddIncludePath(dir+"mhist");
    gInterpreter->AddIncludePath(dir+"mhistmc");
    gInterpreter->AddIncludePath(dir+"mimage");
    gInterpreter->AddIncludePath(dir+"mmain");
    gInterpreter->AddIncludePath(dir+"mmc");
    gInterpreter->AddIncludePath(dir+"mmontecarlo");
    gInterpreter->AddIncludePath(dir+"mpointing");
    gInterpreter->AddIncludePath(dir+"mranforest");
    gInterpreter->AddIncludePath(dir+"mraw");
    gInterpreter->AddIncludePath(dir+"mreflector");
    gInterpreter->AddIncludePath(dir+"mreport");
    gInterpreter->AddIncludePath(dir+"mtools");

    if (TString("linux")==gSystem->GetBuildArch())
    {
        TString options = " -O -pipe -Wall -Woverloaded-virtual -fno-exceptions -fPIC ";

        TString s = "cd $BuildDir ; ";
        s += "g++ -c" + options + "-Iinclude -D_REENTRANT $IncludePath $SourceFiles ; ";
        s += "g++ $ObjectFiles -shared -Wl,-soname,$LibName.so -O -o $SharedLib";
        gSystem->SetMakeSharedLib(s);
    }

    cout << "\033[32m" << "Welcome to the Mars Root environment." << "\033[0m" << endl;
    cout << endl;
}
