/////////////////////////////////////////////////////////////////////////////
//
// This is an easy implementation of the Merging process (as root Macro)
//
// at the moment it reads a binary file ("rawtest.bin") which was written
// in the DAQ raw format.
//
// The data are stored in root container objects (classes derived from
// TObject like MRawRunHeader)
//
// This containers are written to a root file ("rawtest.root")
//
/////////////////////////////////////////////////////////////////////////////

int merpp()
{
    //
    // create a (empty) list of parameters which can be used by the tasks
    // and an (empty) list of tasks which should be executed
    //
    MParList *plist  = new MParList;
    MTaskList *tasks = new MTaskList;

    //
    // create the tasks which should be executed and add them to the list
    // in the case you don't need parameter containers, all of them can
    // be created by MRawFileRead::PreProcess
    //
    // REMARK: Don't change the order of the two instantiations.
    //         I don't have an idea why, but here it crashes to
    //         Interpreter.
    //         (Using root 2.25/03, with Cint 5.14.50 on OSF1)
    //
    MRawFileWrite *writer = new MRawFileWrite("rawtest.root", "RECREATE");
    MRawFileRead  *reader = new MRawFileRead("rawtest.bin");
    tasks->AddToList(reader);
    tasks->AddToList(writer);

    //
    // create the looping object and thell it about the parameters to use
    // and the tasks to execute
    //
    MEvtLoop magic;

    magic.SetParList(plist);
    magic.SetTaskList(tasks);

    //
    // Start the eventloop which reads the raw file (MRawFileRead) and
    // write all the information into a root file (MRawFileWrite)
    //
    // between reading and writing we can do, transformations, checks, etc.
    // (I'm think of a task like MRawDataCheck)
    //
    magic.Eventloop();

    return 0;
}


