void optimonoff()
{
    MJOptimizeCuts opt("MHThetaSq");
    opt.SetDebug(2);
    opt.SetOptimizer(MJOptimize::kSimplex);

    // ------------------- Xi -----------------------
    opt.SetParameter(0, 0.6);
    opt.FixParameter(6, 0.137);

    // --------------- Theta Sq ---------------------
    opt.SetParameter(1, 0.23);

    // ----------------- Area -----------------------
    opt.SetParameter(2, 0.25);
    opt.SetParameter(3, 5.21);
    opt.SetParameter(4, 0.11);

    // ----------------- M3L ------------------------
    opt.SetParameter(5, -0.089);

    // ----------------- Fit ------------------------

    MAlphaFitter fit;
    fit.SetScaleMode(MAlphaFitter::kBackground);
    fit.SetBackgroundMin(0.4);
    fit.SetBackgroundMax(0.6);
    fit.SetPolynomOrder(1);
    fit.SetSignalFunction(MAlphaFitter::kThetaSq);
    fit.SetMinimizationStrategy(MAlphaFitter::kSignificanceLogExcess);

    // ----------------- Cuts -----------------------

    MFMagicCuts cuts;
    cuts.SetAlphaCut(MFMagicCuts::kNoCuts);

    // -----------------------------------------------------------

    MStatusDisplay *d = new MStatusDisplay;
    opt.SetDisplay(d);

    opt.RunOnOff("onofflza-abs.root", &cuts, &fit);
}
