void optimonoff()
{
    MJOptimizeCuts opt("MHThetaSq");
    opt.SetDebug(2);
    opt.SetOptimizer(MJOptimize::kSimplex);

    // ------------------- Xi -----------------------
    opt.FixParameter(0, 1.3245);
    opt.FixParameter(6, 8.2957);
    opt.FixParameter(7, 0.8677);

    // --------------- Theta Sq ---------------------
    opt.SetParameter(1, 0.2087);

    // ----------------- Area -----------------------
    opt.SetParameter(2, 0.2292);
    opt.SetParameter(3, 5.2652);
    opt.SetParameter(4, 0.09893);

    // ----------------- M3L ------------------------
    opt.SetParameter(5, -0.08295);

    // ----------------- Fit ------------------------

    MAlphaFitter fit;
    fit.SetScaleMode(MAlphaFitter::kBackground);
    fit.SetBackgroundFitMin(0.12);
    fit.SetBackgroundFitMax(0.5);
    fit.SetPolynomOrder(1);
    fit.SetSignalFunction(MAlphaFitter::kThetaSq);
    fit.SetMinimizationStrategy(MAlphaFitter::kSignificanceLogExcess);

    // ----------------- Cuts -----------------------

    MFMagicCuts cuts;
    cuts.SetThetaCut(MFMagicCuts::kNone);

    // -----------------------------------------------------------

    MStatusDisplay *d = new MStatusDisplay;
    opt.SetDisplay(d);

    opt.RunOnOff("1218phd/ganymed00001220-summary.root", &cuts, &fit);
}
