/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz, 11/2005 <mailto:tbretz@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2006
!
!
\* ======================================================================== *//////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
// trainenergy.C
// =============
//
// Trains a random forest for energy estimation.
//
// The additional code below shows how the MagicCuts can be used in
// training and testing. There is also code which allows to change the
// slope of the input spectrum. If a min- or max-break energy is given
// the new slope is only applied in this region. Further possibilities
// for additional cuts are shown.
//
/////////////////////////////////////////////////////////////////////////////
void trainenergy()
{
    MDataSet set("mcdataset.txt");
    set.SetNumAnalysis(1);            // Necessary

    MJTrainEnergy opt;
    //opt.SetDebug();

    // ------- Parameters to train Random Forest --------
    opt.AddParameter("MHillas.fSize");
    opt.AddParameter("MHillasSrc.fDist");
    opt.AddParameter("MPointingPos.fZd");
    opt.AddParameter("MHillas.GetArea");
    opt.AddParameter("MNewImagePar.fUsedArea");
    opt.AddParameter("MNewImagePar.fCoreArea");
    opt.AddParameter("MNewImagePar.fLeakage1");
    opt.AddParameter("MNewImagePar.fLeakage2");
    opt.AddParameter("MNewImagePar.fConc");
    opt.AddParameter("MNewImagePar.fConc1");

    // -------------------- Run ----------------------------

    MStatusDisplay *d = new MStatusDisplay;
    opt.SetDisplay(d);

    /*
     -------------------- Magic-Cuts ----------------------
     MFMagicCuts cuts;
     cuts.SetHadronnessCut(MFMagicCuts::kArea);
     cuts.SetThetaCut(MFMagicCuts::kOn);

     TArrayD arr(10);
     arr[0]=  1.3245;
     arr[1]=  0.208700;
     arr[2]=  0.229200;
     arr[3]=  5.305200;
     arr[4]=  0.098930;
     arr[5]= -0.082950;
     arr[6]=  8.2957;
     arr[7]=  0.8677;

     cuts.SetVariables(arr);

     opt.AddPreCut(&cuts);

     -------------------- Energy Slope --------------------
     MFEnergySlope slope(-2.8); // New slope for mc spectrum
     slope.SetMcMinEnergy(80);  // Set break energy from -2.6 to -2.8
     opt.AddPreCut(&slope);     // throw away events to change slope

     -------------------- Other cuts ----------------------
     opt.AddPreCut("MHillasSrc.fDist*MGeomCam.fConvMm2Deg<1.0");
     opt.AddPreCut("MHillas.fSize>200");
    */

    // Things which could be implemented in a future version
    // PreCut in Energy oder Size?
    // PreCut in Max Dist
    // PreCut in Theta^2 (0.25 oder 0.3)
    // New spectral slope
    // Zenith angle distribution in OnTime

     opt.Train("rf-energy.root", set, 30000);
}
/*
 // SequencesOn:   Monte Carlo Sequences used for training
 // SequencesOff:  Monte Carlo Sequences used for testing

 // Use:
 // opt.AddPreCut    to use cut for test and training
 // opt.AddTestCut   to use cut for test only
 // opt.AddTrainCut  to use cut for train only
 */
