void getThreshold( char* filename = "/hdb1/users/jlopez/temp_loop.root")
{
    //
    // This macro fill the container MHMcEnergies using the task
    // MMcThresholdCalc and shows the results.
    //
    MParList  parlist;

    MTaskList tasklist;
    parlist.AddToList(&tasklist);

    //
    // Setup the parameter list
    // - You need create the container MHMcEnergies.
    //    + You need to put the number of trigger conditions when
    //      you declarete the MHMcEnergies
    //    + If you don't put any dimension to MHMcEnergies it works
    //      taking only the trigger information from MMcTrig
    //
    const UInt_t numtriggerconditions = 5;

    MHMcEnergies *hists = new MHMcEnergies(numtriggerconditions);
    hists->AddEntriesToList(&parlist);

    //
    // Setup the task list
    // - You need the read and the MMcThresholdCalc tasks
    // - You have to fill the histograms for the Energy threshold
    //    + You need to put the number of trigger conditions when
    //      you declarete the MMcThresholdCalc
    //    + If you don't put any dimension to MMcThresholdCalc it works
    //      like one dimension MMcThresholdCalc
    //
    MReadTree        read("Events", filename);
    MMcThresholdCalc calc(numtriggerconditions);

    tasklist.AddToList(&read);
    tasklist.AddToList(&calc);

    MEvtLoop evtloop;
    evtloop.SetParList(&parlist);

    //
    // Begin the loop
    //
    evtloop.Eventloop();

    //
    // Now you can display the results
    //
    for (UInt_t i=0; i<numtriggerconditions; i++) {
        ((*hists)[i]).Draw();
	if (getchar()=='q') break;
    }
}
