void MagicHillas()
{
    //
    // This is a demonstration program which calculates the Hillas
    // parameter out of a Magic root file.

    //
    // Create a empty Parameter List and an empty Task List
    // The tasklist is identified in the eventloop by its name
    //
    MParList  plist;

    MTaskList tlist;
    plist->AddToList(&tlist);

    //
    // The geometry container must be created by yourself to make sure
    // that you don't choos a wrong geometry by chance
    //
    MGeomCamMagic geomcam;
    plist->AddToList(&geomcam);

    MPedestalCam pedest;
    plist->AddToList(&pedest);

    //
    // The Hillas histograms (MHHillas) could be created automatically
    // but to make sure, that they are not deleted when the macro is
    // finished you must create them yourself and add it to the list
    //
    MHHillas *hists = new MHHillas;
    plist->AddToList(hists);

    MHStarMap *smap = new MHStarMap;
    plist->AddToList(smap);

    //
    // Now setup the tasks and tasklist:
    //
    //  1) read in the data from a magic root file   MReadTree
    //  2) calculate number of cerenkov photons      MCerPhotCalc
    //  3) clean the image                           MImgCleanStd
    //  4) calculate hillas                          MHillasCalc
    //  5) fill the hillas into the histograms       MFillHHillas
    //

    //
    // The first argument is the tree you want to read.
    //   Events:     Cosmic ray events
    //   PedEvents:  Pedestal Events
    //   CalEvents:  Calibration Events
    //
    MReadTree read("Events", "data/cer000020.root");
    // read.AddFile("data/cer000019.root");

    MCerPhotCalc    ncalc;
    MImgCleanStd    clean;
    MHillasCalc     hcalc;
    MFillH          hfill("MHillas", "MHHillas");
    MFillHStarMap   sfill("MHillas", "MHStarMap");
    MWriteRootFile write("hillas.root");
    write.AddContainer("MHillas");
    write.AddContainer("MHHillas");
    write.AddContainer(smap);

    tlist.AddToList(&read);
    tlist.AddToList(&ncalc);
    tlist.AddToList(&clean);
    tlist.AddToList(&hcalc);
    tlist.AddToList(&hfill);
    tlist.AddToList(&sfill);
    tlist.AddToList(&write);

    //
    // Create and setup the eventloop
    //
    MEvtLoop evtloop;
    evtloop.SetParList(&plist);

    //
    // Execute your analysis
    //
    if (!evtloop.Eventloop())
        return;

    //
    // After the analysis is finished we can display the histograms
    //
    hists->Draw();
    smap->Draw();
}

