/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz 5/2002 <mailto:tbretz@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2002
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
// MHadroness
//
// The Value must be in the range [0,1]
// It should be the value used for gamma/hadron seperation.
// For quality histograms look at MHHadroness
//
/////////////////////////////////////////////////////////////////////////////
#include "MHadroness.h"

#include "MLog.h"
#include "MLogManip.h"

ClassImp(MHadroness);

// --------------------------------------------------------------------------
//
// Default constructor.
//
MHadroness::MHadroness(const char *name, const char *title)
    : fHadroness(-1)
{
    fName  = name  ? name  : "MHadroness";
    fTitle = title ? title : "Storage container for hadroness value";
}

// --------------------------------------------------------------------------
//
// Reset hadroness, -1 indicates: invalid value
//
void MHadroness::Reset()
{
    fHadroness = -1;
}

// --------------------------------------------------------------------------
//
// Print the hillas Parameters to *fLog
//
void MHadroness::Print(Option_t *) const
{
    *fLog << all << GetDescriptor() << ": Hadroness = " << fHadroness << endl;
}

