#ifndef MARS_MPadSchweizer
#define MARS_MPadSchweizer

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef MARS_MH
#include "MH.h"
#endif

#include "TRandom3.h"
#include "TH1.h"
#include "TH2.h"
#include "TH3.h"
#include "TProfile.h"


class MGeomCam;
class MCerPhotEvt;
class MPedestalCam;
class MMcEvt;
class MPedestalCam;
class MSigmabar;
class MParList;

class MPadSchweizer : public MTask
{
private:
    MGeomCam       *fCam; 
    MCerPhotEvt    *fEvt; 
    MSigmabar      *fSigmabar;
    MMcEvt         *fMcEvt;
    MPedestalCam   *fPed;

    TRandom3       *fRnd;

    Int_t          fPadFlag;
    Int_t          fRunType;
    Int_t          fGroup;

    // plots used for the padding
    TH2D           *fHSigmaTheta;    // 2D-histogram (sigmabar vs. Theta)
    TH3D           *fHSigmaPixTheta; // 3D-histogram (Theta, pixel, sigma)
    TH3D           *fHDiffPixTheta;  // 3D-histogram (Theta, pixel, sigma^2-sigmabar^2)

    // plots for checking the padding
    TH2D           *fHSigmaPedestal; // 2D-histogram : pedestal sigma after
                                     //                versus before padding
    TH2D           *fHPhotons;       // 2D-histogram : no.of photons after
                                     //                versus before padding
    TH2D           *fHSigbarTheta;   // 2D-histogram : sigmabar vs. Theta
                                     //                (after padding)
    TH1D           *fHNSB;           // 1D-histogram : additional NSB

    TH3D           *fHSigPixTh;      // 3D : Theta, pixel, pedestal sigma 
                                     //      (after padding)
    TH3D           *fHDiffPixTh;     // 3D : Theta, pixel, sigma^2-sigmabar^2 
                                     //      (after padding)


public:
    MPadSchweizer(const char *name, const char *title,
                  TH2D *fHist2, TH3D *fHist3, TH3D *fHist3Diff);
    ~MPadSchweizer();

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();
    Bool_t PostProcess();
    
    void SetPadFlag(Int_t padflag);
    void SetRunType(Int_t runtype) { fRunType =  runtype; }
    void SetGroup(Int_t group)     { fGroup   =  group; }

    ClassDef(MPadSchweizer, 1)    // task for the padding (Schweizer)
}; 

#endif









