#ifndef MARS_MNewImagePar
#define MARS_MNewImagePar

#ifndef MARS_MHillas
#include "MHillas.h"
#endif

class MSrcPosCam;

class MNewImagePar : public MParContainer
{
private:
    Float_t fLeakage1;   // (photons in most outer ring of pixels) over fSize
    Float_t fLeakage2;   // (photons in the 2 outer rings of pixels) over fSize

public:
    MNewImagePar(const char *name=NULL, const char *title=NULL);

    //    void SetSrcPos(MSrcPosCam *pos) { fSrcPos = pos; }
    //    const MSrcPosCam *GetSrcPos() const   { return fSrcPos; }

    void Reset();

    Float_t GetLeakage1()        const { return fLeakage1; }
    Float_t GetLeakage2()        const { return fLeakage2; }

    void Print(Option_t *opt=NULL) const;

    virtual Bool_t Calc(const MGeomCam &geom, const MCerPhotEvt &evt,
                        const MHillas *hillas);

    //virtual void AsciiRead(ifstream &fin);
    //virtual void AsciiWrite(ofstream &fout) const;

    ClassDef(MNewImagePar, 1) // Container to hold new image parameters
};

#endif



























