#ifndef MARS_MApplyPadding
#define MARS_MApplyPadding

#ifndef MARS_MTask
#include "MTask.h"
#endif

#include "TRandom3.h"
#include "TH1.h"
#include "TH2.h"

class MGeomCam;
class MCerPhotEvt;
class MPedestalCam;
class MMcEvt;
class MPedestalCam;
class MSigmabar;
class MParList;

class MApplyPadding : public MTask
{
private:
    const MGeomCam *fCam; 
    MCerPhotEvt *fEvt; 
    MSigmabar *fSigmabar;
    TRandom3 fRnd;
    Int_t fRunType;
    Int_t fGroup;
    char *fDatabaseFilename;
    TH1D *fHSigmabarMax;
    MMcEvt *fMcEvt;
    MPedestalCam *fPed;
    TH2D *fTest;
    Bool_t fUseHistogram;
    Double_t fFixedSigmabar;

public:
    MApplyPadding(const char *name=NULL, const char *title=NULL);

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();
    
    void SetRunType(Int_t runtype) { fRunType =  runtype; }
    void SetGroup(Int_t group)     { fGroup   =  group; }
    void SetDatabaseFile(char *filename) { fDatabaseFilename = filename; }
    void SetTargetLevel(Double_t sigmabar) { fFixedSigmabar = sigmabar; fUseHistogram=kFALSE; }
    void SetDefiningHistogram(TH1D *histo);

    ClassDef(MApplyPadding, 1)    // task for applying padding
}; 

#endif

